//******************************************************************************
//
//	File:		progressbar.h
//
//	Description:	Header file for RAMPulse(tm)
//
//******************************************************************************

/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/

#ifndef PBAR_H
#define PBAR_H

#ifndef _VIEW_H
#include <View.h>
#endif
	
typedef struct {
	int32	shade;
	BRect	rect;
	} segment;
	
#define ltgray 216
#define dkgray 80

class TProgressBar : public BView {
public:
	enum {
		PROGRESS_WIDTH	= 146,
		PROGRESS_HEIGHT	= 20
	};
					TProgressBar(BRect r, char* name, int32 initial, 
								bool warn = FALSE, int32 warnVal = 85);
virtual	void		Draw(BRect updateRect);
		void		Render(bool drawAll = FALSE);
		void		DrawSegment(int32 n);
		void		Set(int32 value);
inline double		PrevTick()					{ return fPrevTick; }
inline void			SetPrev(double theTick)		{ fPrevTick = theTick; } 

private:	
	segment		segments[20];
	float		fWidth;		// Width/height of bar
	int32		fCurrent;	// Int from 1-100
	int32		fPrevious;	// Int from 1-100
	double		fPrevTick;	// Last CPU idle thread time
	bool		fWarning;	
	int32		fWarnVal;	// Change bar color if over fWarnValue
};

#endif
