#include <Application.h> 
#include <InterfaceKit.h>
#include <Rect.h>
#include <StorageKit.h> 
#include <stdio.h> 
#include <string.h> 
#include <TrackerAddon.h>
#include <String.h>

#include "FtpClient.h"

void process_refs(entry_ref dir_ref, BMessage *msg, void *);

int32	ClientThread(void *data);


// this view holds the information on servers and the UI
class ServerView : public BView {
public:
				ServerView(BRect bounds, const char *server, const char *path, const char* user, const char *pass, bool passive);
				~ServerView();
virtual void	MessageReceived(BMessage *msg);
virtual void	AttachedToWindow();
virtual void	Draw(BRect updateRect);
	const char 	*GetHost();
	const char 	*GetUser();
	const char 	*GetPath();
	const char 	*GetPass();
	bool		GetPassive() { return mPassiveBox->Value() != 0; }
	bool		CreateDirectoryFor(const char *newDirectory, FtpClient *client);
	bool		SetBusy(bool busy);
	bool		AmountTransfered(float amount); //adds amount to total amount transfered
	bool		SetTotalAmount(float amount); //sets the total amount to transfer
	bool		SetMessage(const char *message);
	
private:
	BTextControl	*mHostView;
	BTextControl	*mUserView;
	BTextControl	*mPathView;
	BTextControl	*mPassView;
	BButton			*mGoButton;
	BBitmap			*mIcon;
	BTextView		*mMessageView;
	BStatusBar		*mStatusBar;
	BCheckBox		*mPassiveBox;
	thread_id		mClientThread;
	bool			mClientBusy;
	BLocker			mClientLock;
	float			mAmountTransfered;
	float			mTotalAmount;
};

class FIWindow : public BWindow {
public:
				FIWindow(entry_ref dir_ref, BMessage *msg);
				~FIWindow();
	BList		*GetPathList() { return &mPathList; }
	BPath	 	*GetWorkingDirectory() { return &mWorkingDirectory;}
virtual bool	QuitRequested();

private:
	//adds the entry to the list (and all subdirectories, is a dir) and returns the sum size
	int32		AddEntry(const entry_ref *entryRef);
	bool		ReadSettings(BString &host, BString &path, BString &user, BString &pass, bool &passive);
	bool		WriteSettings(const char *host, const char *path, const char *user, const char *pass, bool passive);
	ServerView	*mServerView;
	BList		mPathList;
	BPath		mWorkingDirectory;
};
