// SampleApp.cpp
// by Hiroshi Lockheimer

#include "attr_test.h"
#include "attr_Window.h"
#include <Path.h>
#include <NodeInfo.h>
#include <Node.h>
#include <Mime.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int main(int argc, char **argv)
{
	if (1)
	{
		TSampleApp *sampleApp = new TSampleApp();
		if (sampleApp != NULL) {
			sampleApp->Run();
			delete (sampleApp);
		}
	}
	else if (argc > 1)
	{
		long i;
		for(i=1; i<argc; i++)
		{
			printf("file \"%s\"\n", argv[i]);
			char s[1024];
			getcwd(s, 1023);
			BPath path(s, argv[i]);
			printf("Path is \"%s\"\n", path.Path());
			BNode node(path.Path());
			BNodeInfo info(&node);
			char type[B_MIME_TYPE_LENGTH];
			char sign[B_MIME_TYPE_LENGTH];
			info.GetType(type);
			info.GetPreferredApp(sign);
			printf("file type \"%s\"\n", type);
			printf("file app  \"%s\"\n", sign);

#define POSTFIX(x,n) (len > n && strncmp(&leaf[len-n], x, n) == 0)

			// set to text/HTML
			char *leaf = argv[i];
			long len = strlen(leaf);
			if (strcmp(type, "text/html") != 0 && POSTFIX(".html",5))
			{
				info.SetType("text/html");
				//info.SetPreferredApp("application/x-vnd.Be-NPOS");
			}
		}
	}
	else
	{
		BMimeType mime;
		char s[B_MIME_TYPE_LENGTH];
		BMessage super;
		BMessage type;
		
		printf("Exploration of mime types...\n");
		if (mime.GetInstalledSupertypes(&super) == B_NO_ERROR)
		{
			printf("List of super types\n");
			long i=0;
			char *s2 = NULL;
			while(super.FindString("super_types", i, &s2) >= B_NO_ERROR)
				printf("super type[%2d] = \"%s\"\n", i++, s2);
		}
		
		printf("Exploration of installed types\n");
		if (mime.GetInstalledTypes(&type) == B_NO_ERROR)
		{
			printf("List of installed types\n");
			long i=0;
			char *s2 = NULL;
			while(type.FindString("types", i, &s2) >= B_NO_ERROR)
				printf("type type[%2d] = \"%s\"\n", i++, s2);
		}
	}
	return (B_NO_ERROR);
}


TSampleApp::TSampleApp()
	: BApplication("application/x-ralf-attr.test")
{
}


void
TSampleApp::ReadyToRun()
{
	if (TSampleWindow::CountWindows() < 1)
		PostMessage(MSG_NewSample1Window);
}


void
TSampleApp::MessageReceived(
	BMessage	*message)
{
	switch (message->what) {
		case MSG_NewSample1Window:
		{
			TSampleWindow *sampleWin = new TSampleWindow();
			if (sampleWin != NULL)
				sampleWin->Show();
			break;
		}		
		
		case MSG_SampleWindowRemoved:
			if (TSampleWindow::CountWindows() < 1)
				PostMessage(B_QUIT_REQUESTED);
			break;
			
		default:
			BApplication::MessageReceived(message);
			break;
	}
}


void
TSampleApp::ArgvReceived(
	int32	argc,
	char	*argv[])
{
	printf("app argv received\n");

}


void TSampleApp::RefsReceived(BMessage *message)
{
entry_ref ref;
int32 count;
uint32 type;

	printf("app refs received\n");
	message->GetInfo("refs", &type, &count);
	if (type == B_REF_TYPE)
	{
		long i;
		for(i = --count; i>=0; i--)
			if (message->FindRef("refs", i, &ref) == B_OK)
			{
				TSampleWindow *sampleWin = new TSampleWindow();
				if (sampleWin == NULL) continue;
				BMessage msg('GoTo');
				msg.AddRef("refs", &ref);
				sampleWin->PostMessage(&msg);
				sampleWin->Show();
			}
	}
}


