// SampleWindow.cpp
// by Hiroshi Lockheimer

#include "attr_Window.h"
#include <Application.h>
#include <Box.h>
#include <Button.h>
#include <CheckBox.h>
#include <Menu.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <RadioButton.h>
#include <TextControl.h>
#include <Path.h>
#include <NodeInfo.h>
#include <ctype.h>

// constants for the window
BRect		kWindowFrame(20, 20, 420, 220);

// static member variable
int32 TSampleWindow::sWindowCount = 0;

#ifndef max
#define max(a,b) ((a)<(b) ? (b) : (a))
#endif

// ----------------------------------------------------
// TSampleWindow constructor
// ----------------------------------------------------

TSampleWindow::TSampleWindow(void)
		: BWindow(BRect(20+10*sWindowCount,30+10*sWindowCount,420+10*sWindowCount,220+10*sWindowCount),
				  "Type Setter", B_TITLED_WINDOW, 
				  B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
	atomic_add(&sWindowCount, 1);
	textName = NULL;
	textPath = NULL;
	textType = NULL;
	textApp = NULL;
	menuPrefApp = NULL;
	modifyItem = NULL;
	modifyButton = NULL;
	InitWindow();
}


// ----------------------------------------------------
// TSampleWindow destructor
// ----------------------------------------------------

TSampleWindow::~TSampleWindow()
{
	atomic_add(&sWindowCount, -1);
	be_app->PostMessage(MSG_SampleWindowRemoved);
}


// ----------------------------------------------------
// MessageReceived - respond to messages
// ----------------------------------------------------

void
TSampleWindow::MessageReceived(BMessage	*message)
{
entry_ref ref;
void *ptr;
BMenuItem *item;

	if (message->HasRef("refs"))
	{
		// contains one ref to display
		if (message->FindRef("refs", 0, &ref) == B_OK) gotoFile(ref);
		for(long i=1; message->FindRef("refs", i, &ref) == B_OK; i++)
		{
			BMessage msg(B_REFS_RECEIVED);
			msg.AddRef("refs", &ref);
			be_app->PostMessage(&msg);
		}
	}
	else switch(message->what)
	{
		case 'Type':
		case 'Appe':
			modified(true);
			break;
		case 'MiTy':
			message->FindPointer("source", &ptr);
			//item = dynamic_cast<BMenuItem *>(ptr);
			item = (BMenuItem *)ptr;
			if (item && textType)
			{
				textType->SetText(item->Label());
				updatePrefApp();
				modified(true);
			}
			break;
		case 'PrAp':
			message->FindPointer("source", &ptr);
			//item = dynamic_cast<BMenuItem *>(ptr);
			item = (BMenuItem *)ptr;
			if (item && textApp)
			{
				textApp->SetText(item->Label());
				modified(true);
			}
			break;
		case 'ModF':
			modify();
			break;
		default:
			//message->PrintToStream();
			break;
	}
}


// ----------------------------------------------------
// CountWindows - return the number of TSampleWindows
// ----------------------------------------------------

int32 TSampleWindow::CountWindows()
{
	return (atomic_add(&sWindowCount, 0));	
}


// ----------------------------------------------------
// InitWindow - do interesting things to the window
// ----------------------------------------------------

void
TSampleWindow::InitWindow(void)
{
	// lock the window before we try to do anything
	if (!Lock()) return;
		
	BRect bounds = Bounds();

	// BMenuBars will resize themseleves vertically for you,
	// simply pass it the BWindow bounds
	BRect 		menuBarFrame = bounds;
	BMenuBar	*menuBar = new BMenuBar(menuBarFrame, B_EMPTY_STRING);

	// create a new BMenu
	BMenu		*menu = new BMenu("Atlantide");
	BMenuItem	*menuItem = NULL;
	modifyItem = new BMenuItem("Modify",	new BMessage('ModF'), 'F');
	menu->AddItem(modifyItem);							

	menu->AddSeparatorItem();
	
	menuItem = new BMenuItem("Close", new BMessage(B_CLOSE_REQUESTED), 'W');
	menu->AddItem(menuItem);
	menuItem = new BMenuItem("Close All", new BMessage(B_QUIT_REQUESTED), 'Q');
	menuItem->SetTarget(be_app);
	menu->AddItem(menuItem);
	
	// add the BMenu to the BMenuBar, and then add it to the window			  
	menuBar->AddItem(menu);

	// create stuff for changing MIME types
	menu = new BMenu("MIME types");

	// add one category per super_types and one submenu per type
	BMessage super;
	BMessage type;
	BMimeType mime;
	mime.GetInstalledSupertypes(&super);
	mime.GetInstalledTypes(&type);

	if(menu)
	{
		long i=0;
		char *s = NULL;
		while(super.FindString("super_types", i++, &s) >= B_NO_ERROR)
		{
			BMenu *sub = new BMenu(s);

			char s3[B_MIME_TYPE_LENGTH];
			sprintf(s3,"%s/", s);
			long len3=strlen(s3);

			long i=0;
			char *s2 = NULL;
			while(type.FindString("types", i++, &s2) >= B_NO_ERROR)
				if (strncmp(s3,s2,len3) == 0)
					sub->AddItem(new BMenuItem(s2, new BMessage('MiTy')));

			menu->AddItem(sub);
		}
	}
	menuBar->AddItem(menu);

	// create stuff for Preferred Apps
	menuPrefApp = new BMenu("Preferred Apps");

	if(menu)
	{
		char s3[B_MIME_TYPE_LENGTH]="application/";
		long len3=strlen(s3);

		BMenu *sub = new BMenu("All apps");

		long i=0;
		char *s2 = NULL;
		while(type.FindString("types", i++, &s2) >= B_NO_ERROR)
			if (strncmp(s3,s2,len3) == 0)
				sub->AddItem(new BMenuItem(s2, new BMessage('PrAp')));

		menuPrefApp->AddItem(sub);
	}	

	menuBar->AddItem(menuPrefApp);

/*
	// some test stuff
	menu = new BMenu("Test");
	BMenu *sub = new BMenu("UAYOR");
	sub->AddItem(new BMenuItem("Use", NULL));
	sub->AddItem(new BMenuItem("At", NULL));
	sub->AddItem(new BMenuItem("Your", NULL));
	sub->AddItem(new BMenuItem("Own", NULL));
	sub->AddItem(new BMenuItem("Risk", NULL));
	menu->AddItem(sub);
	sub = new BMenu("UTSL");
	sub->AddItem(new BMenuItem("Use", NULL));
	sub->AddItem(new BMenuItem("The", NULL));
	sub->AddItem(new BMenuItem("Source", NULL));
	sub->AddItem(new BMenuItem("Luke", NULL));
	menu->AddItem(sub);
	menuBar->AddItem(menu);
*/

	AddChild(menuBar);

	
	// get the menubar's height, and exclude it from 'bounds'
	bounds.top += menuBar->Frame().Height();

	BView *base = new BView(bounds, B_EMPTY_STRING, B_FOLLOW_ALL, B_WILL_DRAW);
	base->SetViewColor(230, 230, 230);
	AddChild(base);

	// place the Interface Kit elements relative to the BBox's
	// bounds
	// note that the height of their frames are set to 0.0,
	// the kit elements will automatically set their heights to
	// something reasonable in their constructors
	bounds = base->Bounds();

	BRect rect;

	rect.left = bounds.left + 10.0;
	rect.top = bounds.top + 10.0;
	rect.right = bounds.right - 10.0;
	rect.bottom = rect.top;
	textName = new BTextControl(rect, "File name", "File name",
																"(drop a file in this view)", new BMessage('Name'));
	base->AddChild(textName);

	rect = textName->Frame();
	rect.OffsetBy(0.0, rect.Height()+ 10.0);
	textPath = new BTextControl(rect, "Path name", "Path name",
																"", new BMessage('Path'));
	base->AddChild(textPath);

	rect.OffsetBy(0.0, rect.Height()+ 10.0);
	textType = new BTextControl(rect, "MIME Type", "MIME Type",
																"", new BMessage('Type'));
	base->AddChild(textType);

	rect.OffsetBy(0.0, rect.Height()+ 10.0);
	textApp = new BTextControl(rect, "Preferred App", "Preferred App",
																"", new BMessage('Appe'));
	base->AddChild(textApp);

	long n=20;
	n = max(textName->StringWidth("File name"), n);
	n = max(textPath->StringWidth("Path name"), n);
	n = max(textType->StringWidth("MIME Type"), n);
	n = max(textApp->StringWidth("Preferred App"), n);
	textName->SetDivider(n + 2.0);
	textPath->SetDivider(n + 2.0);
	textType->SetDivider(n + 2.0);
	textApp->SetDivider(n + 2.0);

	rect.OffsetBy(n, rect.Height()+ 20.0);
	modifyButton = new BButton(rect, "Modify", "Modify", new BMessage('ModF'));
	modifyButton->ResizeToPreferred();
	base->AddChild(modifyButton);

	rect = modifyButton->Frame();
	rect.OffsetBy(rect.Width()+ 20.0, 0.0);
	BButton *but = new BButton(rect, "Close", "Close", new BMessage(B_CLOSE_REQUESTED));
	but->ResizeToPreferred();
	base->AddChild(but);

	rect = but->Frame();
	rect.OffsetBy(rect.Width()+ 50.0, 0.0);
	but = new BButton(rect, "Close All", "Close All", new BMessage(B_QUIT_REQUESTED));
	but->SetTarget(be_app);
	but->ResizeToPreferred();
	base->AddChild(but);

	// we're done, don't forget to unlock yourselves	
	modified(false);
	Unlock();
}

//*******************************************
void TSampleWindow::gotoFile(entry_ref &ref)
//*******************************************
{
	// Lock before modifying
	Lock();

	theRef = ref;
	BEntry entry(&theRef);
	BPath  path;
	entry.GetPath(&path);

	//printf("file :\npath=%s\nleaf=%s\n", path.Path(), path.Leaf());

	textName->SetText(path.Leaf());
	textPath->SetText(path.Path());

	BNode node(path.Path());
	BNodeInfo info(&node);
	char type[B_MIME_TYPE_LENGTH]="";
	char sign[B_MIME_TYPE_LENGTH]="";
	info.GetType(type);
	info.GetPreferredApp(sign);

	//printf("type : \"%s\"\napp  : \"%s\"\n", type, sign);
	textType->SetText(type);
	textApp->SetText(sign);

	updatePrefApp();
	modified(false);

	// we're done, don't forget to unlock yourselves	
	Unlock();
	
}


//*************************************
void TSampleWindow::updatePrefApp(void)
//*************************************
{
	if (!menuPrefApp || !textType) return;

	Lock();

	const char *s = textType->Text();
	if (strlen(s) == 0 || !isalpha(s[0]) || menuPrefApp->FindItem(s) != NULL)
	{
		Unlock();
		return;
	}

	BMenu *sub = new BMenu(s);
	BMimeType mime(s);

	char sign[B_MIME_TYPE_LENGTH];
	mime.GetPreferredApp(sign);
	sub->AddItem(new BMenuItem(sign, new BMessage('PrAp')));
	menuPrefApp->AddItem(sub);

	Unlock();
}


//**************************************
void TSampleWindow::modified(bool modif)
//**************************************
{
	Lock();
	if (modifyItem) modifyItem->SetEnabled(modif);
	if (modifyButton) modifyButton->SetEnabled(modif);
	Unlock();
}



//**************************************
void TSampleWindow::modify(void)
//**************************************
{
	if (!textType || !textApp) return;

	Lock();

	BEntry entry(&theRef);
	BPath  path;
	entry.GetPath(&path);
	if (entry.InitCheck() >= B_NO_ERROR)
	{
		BNode node(path.Path());
		if (node.InitCheck() >= B_NO_ERROR)
		{
			BNodeInfo info(&node);
			info.SetType(textType->Text());
			info.SetPreferredApp(textApp->Text());
		}
	}

	Unlock();
	PostMessage(B_CLOSE_REQUESTED);
}


	