#if 0
PCICODE.H

  Created automatically from the web using the following URL:
      http://www.halcyon.com/scripts/jboemler/pci/pcicode 
  Software to create and maintain the PCICODE List written by:
      Jim Boemler (jboemler@halcyon.com) 
  This is header number 937, generated 05-05-97.

Too many people have contributed to this list to acknowledge them all, but
a few have provided the majority of the input and deserve special mention:
   Frederic Potter (frederic@cao-vlsi.ibp.fr), who maintains a list for Linux.
   Chris Aston (caston@madge.com) at Madge Networks, who furnished his companys list.
   Thomas Dippon of Hewlett-Packard GmbH, who added a huge list of vendors 
      and devices _after_ it seemed the list was nearly complete.
#endif

typedef struct _PCI_VENTABLE
{
	unsigned short	VenId ;
	char *	VenShort ;
	char *	VenFull ;
}  PCI_VENTABLE, *PPCI_VENTABLE ;

PCI_VENTABLE	PciVenTable [] =
{
	{ 0x003D, "Lockheed Martin", "Lockheed Martin Corp" } ,
	{ 0x0E11, "Compaq", "Compaq" } ,
	{ 0x1000, "SYM", "Symbios Logic Inc." } ,
	{ 0x1002, "ATI", "ATI Technologies" } ,
	{ 0x1003, "ULSI", "ULSI" } ,
	{ 0x1004, "VLSI", "VLSI Technology" } ,
	{ 0x1005, "Avance", "Avance Logic Inc." } ,
	{ 0x1006, "Reply", "Reply Group" } ,
	{ 0x1007, "NetFrame", "Netframe Systems" } ,
	{ 0x1008, "Epson", "Epson" } ,
	{ 0x100A, "Phoenix", "Phoenix Technologies Ltd." } ,
	{ 0x100B, "NSC", "National Semiconductor" } ,
	{ 0x100C, "Tseng", "Tseng Labs" } ,
	{ 0x100D, "AST", "AST Research" } ,
	{ 0x100E, "Weitek", "Weitek" } ,
	{ 0x1010, "VLogic", "Video Logic Ltd." } ,
	{ 0x1011, "DEC", "Digital Equipment Corporation" } ,
	{ 0x1012, "Micronics", "Micronics Computers Inc." } ,
	{ 0x1013, "Cirrus", "Cirrus Logic" } ,
	{ 0x1014, "IBM", "IBM" } ,
	{ 0x1015, "LSIL", "LSI Logic Corp of Canada" } ,
	{ 0x1016, "ICL", "ICL Personal Systems" } ,
	{ 0x1017, "Spea", "Spea Software AG" } ,
	{ 0x1018, "Unisys", "Unisys Systems" } ,
	{ 0x1019, "ECS", "Elitegroup Computer Sys" } ,
	{ 0x101A, "NCR", "NCR/AT&T GIS" } ,
	{ 0x101B, "Vitesse", "Vitesse Semiconductor" } ,
	{ 0x101C, "WD", "Western Digital" } ,
	{ 0x101E, "AMI", "American Megatrends Inc." } ,
	{ 0x101F, "PictureTel", "PictureTel Corp." } ,
	{ 0x1020, "Hitachi", "Hitachi Computer Electronics" } ,
	{ 0x1021, "OKI", "Oki Electric Industry" } ,
	{ 0x1022, "AMD", "Advanced Micro Devices" } ,
	{ 0x1023, "Trident", "Trident Microsystems" } ,
	{ 0x1024, "Zenith", "Zenith Data Systems" } ,
	{ 0x1025, "Acer", "Acer Incorporated" } ,
	{ 0x1028, "Dell", "Dell Computer Corporation" } ,
	{ 0x1029, "Siem-Nix", "Siemens Nixdorf AG" } ,
	{ 0x102A, "LSI", "LSI Logic, Headland Div" } ,
	{ 0x102B, "Matrox", "Matrox" } ,
	{ 0x102C, "C&T", "Chips And Technologies" } ,
	{ 0x102D, "Wyse", "Wyse Technologies" } ,
	{ 0x102E, "Olivetti", "Olivetti Advanced Technology" } ,
	{ 0x102F, "Toshiba", "Toshiba America" } ,
	{ 0x1030, "TMC", "TMC Research" } ,
	{ 0x1031, "MCP", "Micro Computer Products AG" } ,
	{ 0x1032, "Compaq", "Compaq" } ,
	{ 0x1033, "NEC", "NEC Corporation" } ,
	{ 0x1034, "Burndy", "Burndy Corporation" } ,
	{ 0x1035, "C&CRL", "Computer & &Communication Research Lab" } ,
	{ 0x1036, "FDomain", "Future Domain" } ,
	{ 0x1037, "Hitachi", "Hitachi Micro Systems Inc" } ,
	{ 0x1038, "AMP", "AMP Incorporated" } ,
	{ 0x1039, "SIS", "Silicon Integrated System" } ,
	{ 0x103A, "Seiko", "Seiko Epson Corporation" } ,
	{ 0x103B, "Tatung", "Tatung Corp. Of America" } ,
	{ 0x103C, "HP", "Hewlett-Packard Company" } ,
	{ 0x103E, "Solliday", "Solliday Engineering" } ,
	{ 0x103F, "Logic Mod.", "Logic Modeling" } ,
	{ 0x1040, "Kubota", "Kubota Pacific Computer Inc." } ,
	{ 0x1041, "Computrend", "Computrend" } ,
	{ 0x1042, "PC Tech.", "PC Technology" } ,
	{ 0x1043, "Asustek", "Asustek Computer Inc." } ,
	{ 0x1044, "DPT", "Distributed Processing Tech" } ,
	{ 0x1045, "OPTi", "OPTi" } ,
	{ 0x1046, "IPC", "IPC Corporation LTD" } ,
	{ 0x1047, "Genoa", "Genoa Systems Corp." } ,
	{ 0x1048, "ELSA", "ELSA GmbH" } ,
	{ 0x1049, "Fountain", "Fountain Technology" } ,
	{ 0x104A, "SGS", "SGS Thomson Microelectric" } ,
	{ 0x104B, "Buslogoc", "Buslogic" } ,
	{ 0x104C, "TI", "Texas Instruments" } ,
	{ 0x104D, "Sony", "Sony Corporation" } ,
	{ 0x104E, "Oak", "Oak Technology" } ,
	{ 0x104F, "Co-Time", "Co-Time Computer Ltd." } ,
	{ 0x1050, "Winbond", "Winbond" } ,
	{ 0x1051, "Anigma", "Anigma Corp." } ,
	{ 0x1052, "Young", "Young Micro Systems" } ,
	{ 0x1054, "Hitachi", "Hitachi LTD" } ,
	{ 0x1055, "EFAR", "EFAR Microsystems" } ,
	{ 0x1056, "ICL", "ICL" } ,
	{ 0x1057, "Motorola", "Motorola" } ,
	{ 0x1058, "E&TR", "Electronics & Teleccommunication Resear" } ,
	{ 0x1059, "Teknor", "Teknor Microsystems" } ,
	{ 0x105A, "Promise", "Promise Technology" } ,
	{ 0x105B, "Foxconn", "Foxconn International" } ,
	{ 0x105C, "Wipro", "Wipro Infotech Limited" } ,
	{ 0x105D, "Number-Nine", "Number Nine Visual Technology" } ,
	{ 0x105E, "Vtech", "Vtech Engineering Canada Ltd." } ,
	{ 0x105F, "Infotronic", "Infotronic America Inc." } ,
	{ 0x1060, "UMC", "United Microelectronics" } ,
	{ 0x1061, "8x8", "8x8" } ,
	{ 0x1062, "Maspar", "Maspar Computer Corp." } ,
	{ 0x1063, "OOA", "Ocean Office Automation" } ,
	{ 0x1064, "Alcatel", "Alcatel Cit" } ,
	{ 0x1065, "TM", "Texas Microsystems" } ,
	{ 0x1066, "Picopower", "Picopower Technology" } ,
	{ 0x1067, "Mitsubishi", "Mitsubishi Electronics" } ,
	{ 0x1068, "Div. Tech.", "Diversified Technology" } ,
	{ 0x1069, "Mylex", "Mylex Corporation" } ,
	{ 0x106A, "Aten", "Aten Research Inc." } ,
	{ 0x106B, "Apple", "Apple Computer Inc." } ,
	{ 0x106C, "Hyundai", "Hyundai Electronics America" } ,
	{ 0x106D, "Sequent", "Sequent" } ,
	{ 0x106E, "DFI", "DFI Inc." } ,
	{ 0x106F, "CityGate", "City Gate Development LTD" } ,
	{ 0x1070, "Daewoo", "Daewoo Telecom Ltd." } ,
	{ 0x1071, "Mitac", "Mitac" } ,
	{ 0x1072, "GIT", "GIT Co. Ltd." } ,
	{ 0x1073, "Yamaha", "Yamaha Corporation" } ,
	{ 0x1074, "Nexgen", "Nexgen Microsysteme" } ,
	{ 0x1075, "AIR", "Advanced Integration Research" } ,
	{ 0x1076, "Chaintech", "Chaintech Computer Co. Ltd." } ,
	{ 0x1077, "Q Logic", "Q Logic" } ,
	{ 0x1078, "Cyrix", "Cyrix Corporation" } ,
	{ 0x1079, "I-Bus", "I-Bus" } ,
	{ 0x107A, "Networth", "Networth" } ,
	{ 0x107B, "Gateway", "Gateway 2000" } ,
	{ 0x107C, "Goldstar", "Goldstar Co. Ltd." } ,
	{ 0x107D, "Leadtek", "Leadtek Research" } ,
	{ 0x107E, "Interphase", "Interphase Corporation" } ,
	{ 0x107F, "DTC", "Data Technology Corporation" } ,
	{ 0x1080, "Contaq", "Contaq Microsystems" } ,
	{ 0x1081, "Supermac", "Supermac Technology Inc." } ,
	{ 0x1082, "EFA", "EFA Corporation Of America" } ,
	{ 0x1083, "Forex", "Forex Computer Corporation" } ,
	{ 0x1084, "Parador", "Parador" } ,
	{ 0x1085, "Tulip", "Tulip Computers Int'l BV" } ,
	{ 0x1086, "J. Bond", "J. Bond Computer Systems" } ,
	{ 0x1087, "Cache", "Cache Computer" } ,
	{ 0x1088, "MS Son", "Microcomputer Systems (M) Son" } ,
	{ 0x1089, "DG", "Data General Corporation" } ,
	{ 0x108A, "Bit3", "Bit3 Computer" } ,
	{ 0x108C, "Elonex", "Elonex PLC c/o Oakleigh Systems Inc." } ,
	{ 0x108D, "Olicom", "Olicom" } ,
	{ 0x108E, "Sun", "Sun Microsystems" } ,
	{ 0x108F, "Systemsoft", "Systemsoft Corporation" } ,
	{ 0x1090, "Encore", "Encore Computer Corporation" } ,
	{ 0x1091, "Intergraph", "Intergraph Corporation" } ,
	{ 0x1092, "Diamond", "Diamond Computer Systems" } ,
	{ 0x1093, "Nat. Inst.", "National Instruments" } ,
	{ 0x1094, "FIC", "First Int'l Computers" } ,
	{ 0x1095, "CMD", "CMD Technology Inc." } ,
	{ 0x1096, "Alacron", "Alacron" } ,
	{ 0x1097, "Appian", "Appian Technology" } ,
	{ 0x1098, "Quantum", "Quantum Designs Ltd." } ,
	{ 0x1099, "Samsung", "Samsung Electronics Co. Ltd." } ,
	{ 0x109A, "Packard-Bell", "Packard Bell" } ,
	{ 0x109B, "Gemlight", "Gemlight Computer Ltd." } ,
	{ 0x109C, "Megachips", "Megachips Corporation" } ,
	{ 0x109D, "Zida", "Zida Technologies Ltd." } ,
	{ 0x109E, "Brooktree", "Brooktree Corporation" } ,
	{ 0x109F, "Trigem", "Trigem Computer Inc." } ,
	{ 0x10A0, "Meidensha", "Meidensha Corporation" } ,
	{ 0x10A1, "Juko", "Juko Electronics Inc. Ltd." } ,
	{ 0x10A2, "Quantum", "Quantum Corporation" } ,
	{ 0x10A3, "Everex", "Everex Systems Inc." } ,
	{ 0x10A4, "Globe", "Globe Manufacturing Sales" } ,
	{ 0x10A5, "Racal", "Racal Interlan" } ,
	{ 0x10A6, "Informtech", "Informtech Industrial Ltd." } ,
	{ 0x10A7, "Benchmarq", "Benchmarq Microelectronics" } ,
	{ 0x10A8, "Sierra", "Sierra Semiconductor" } ,
	{ 0x10A9, "SG", "Silicon Graphics" } ,
	{ 0x10AA, "ACC", "ACC Microelectronics" } ,
	{ 0x10AB, "Digicom", "Digicom" } ,
	{ 0x10AC, "Honeywell", "Honeywell IASD" } ,
	{ 0x10AD, "Symphony", "Symphony Labs" } ,
	{ 0x10AE, "Cornerstone", "Cornerstone Technology" } ,
	{ 0x10AF, "MS", "Microcomputer Sysytems" } ,
	{ 0x10B0, "Cardexpert", "Cardexpert Technology" } ,
	{ 0x10B1, "Cabletron", "Cabletron Systems Inc." } ,
	{ 0x10B2, "Raytheon", "Raytheon Company" } ,
	{ 0x10B3, "Databook", "Databook Inc." } ,
	{ 0x10B4, "STB", "STB Systems" } ,
	{ 0x10B5, "PLX", "PLX Technology" } ,
	{ 0x10B6, "Madge", "Madge Networks" } ,
	{ 0x10B7, "3Com", "3Com Corporation" } ,
	{ 0x10B8, "Standard", "Standard Microsystems " } ,
	{ 0x10B9, "ALI", "Acer Labs Inc." } ,
	{ 0x10BA, "Mitsubishi", "Mitsubishi Electronics Corp." } ,
	{ 0x10BB, "Dapha", "Dapha Electronics Corporation" } ,
	{ 0x10BC, "ALR", "Advanced Logic Research Inc." } ,
	{ 0x10BD, "Surecom", "Surecom Technology" } ,
	{ 0x10BE, "Tseng", "Tsenglabs International Corp." } ,
	{ 0x10BF, "MOST", "MOST Corp." } ,
	{ 0x10C0, "Boca", "Boca Research Inc." } ,
	{ 0x10C1, "ICM", "ICM Corp. Ltd." } ,
	{ 0x10C2, "Auspex", "Auspex Systems Inc." } ,
	{ 0x10C3, "Samsung", "Samsung Semiconductors" } ,
	{ 0x10C4, "Award", "Award Software Int'l Inc." } ,
	{ 0x10C5, "Xerox", "Xerox Corporation" } ,
	{ 0x10C6, "Rambus", "Rambus Inc." } ,
	{ 0x10C7, "Media Vision", "Media Vision" } ,
	{ 0x10C8, "Neomagic", "Neomagic Corporation" } ,
	{ 0x10C9, "Dataexpert", "Dataexpert Corporation" } ,
	{ 0x10CA, "Fujitsu", "Fujitsu" } ,
	{ 0x10CB, "Omron", "Omron Corporation" } ,
	{ 0x10CC, "Mentor", "Mentor Arc Inc." } ,
	{ 0x10CD, "AdvanSys", "Advanced System Products" } ,
	{ 0x10CE, "Radius", "Radius Inc." } ,
	{ 0x10CF, "TTI", "Citicorp TTI" } ,
	{ 0x10D0, "Fujitsu", "Fujitsu Limited" } ,
	{ 0x10D1, "Future+", "Future+ Systems" } ,
	{ 0x10D2, "Molex", "Molex Incorporated" } ,
	{ 0x10D3, "Jabil", "Jabil Circuit Inc." } ,
	{ 0x10D4, "Hualon", "Hualon Microelectronics" } ,
	{ 0x10D5, "Autologic", "Autologic Inc." } ,
	{ 0x10D6, "Cetia", "Cetia" } ,
	{ 0x10D7, "BCM", "BCM Advanced Research" } ,
	{ 0x10D8, "APL", "Advanced Peripherals Labs" } ,
	{ 0x10D9, "Macronix", "Macronix International Co. Ltd." } ,
	{ 0x10DA, "T-C", "Thomas-Conrad Corporation" } ,
	{ 0x10DB, "Rohm", "Rohm Research" } ,
	{ 0x10DC, "CERN", "CERN/EPC/EDU" } ,
	{ 0x10DD, "E&S", "Evans & Sutherland" } ,
	{ 0x10DE, "Nvidia", "Nvidia Corporation" } ,
	{ 0x10DF, "Emulex", "Emulex Corporation" } ,
	{ 0x10E0, "IMS", "Integrated Micro Solutions" } ,
	{ 0x10E1, "Tekram", "Tekram Technology Corp. Ltd." } ,
	{ 0x10E2, "Aptix", "Aptix Corporation" } ,
	{ 0x10E3, "Newbridge", "Newbridge Microsystems" } ,
	{ 0x10E4, "Tandem", "Tandem Computers" } ,
	{ 0x10E5, "MIC", "Micro Industries Corporation" } ,
	{ 0x10E6, "Gainbery", "Gainbery Computer Products Inc." } ,
	{ 0x10E7, "Vadem", "Vadem" } ,
	{ 0x10E8, "AMCC", "Applied Micro Circuits Corp." } ,
	{ 0x10E9, "Alps", "Alps Electronic Corp. Ltd." } ,
	{ 0x10EA, "Intergraphics", "Integraphics Systems" } ,
	{ 0x10EB, "Artist", "Artist Graphics" } ,
	{ 0x10EC, "Realtek", "Realtek Semiconductor" } ,
	{ 0x10ED, "Ascii", "Ascii Corporation" } ,
	{ 0x10EE, "Xilinx", "Xilinx Corporation" } ,
	{ 0x10EF, "Racore", "Racore Computer Products" } ,
	{ 0x10F0, "Peritek", "Peritek Corporation" } ,
	{ 0x10F1, "Tyan", "Tyan Computer" } ,
	{ 0x10F2, "Achme", "Achme Computer Inc." } ,
	{ 0x10F3, "Alaris", "Alaris Inc." } ,
	{ 0x10F4, "S-Mos", "S-Mos Systems" } ,
	{ 0x10F5, "NKK", "NKK Corporation" } ,
	{ 0x10F6, "Creative", "Creative Electronic Systems SA" } ,
	{ 0x10F7, "Matsushita", "Matsushita Electric Industrial Corp. Lt" } ,
	{ 0x10F8, "Altos", "Altos India Ltd." } ,
	{ 0x10F9, "PC-Direct", "PC Direct" } ,
	{ 0x10FA, "Truevision", "Truevision" } ,
	{ 0x10FB, "Thesys", "Thesys Microelectronic's" } ,
	{ 0x10FC, "I-O", "I-O Data Device Inc." } ,
	{ 0x10FD, "Soyo", "Soyo Technology Corp. Ltd." } ,
	{ 0x10FE, "Fast", "Fast Electronic GmbH" } ,
	{ 0x10FF, "Ncube", "Ncube" } ,
	{ 0x1100, "Jazz", "Jazz Multimedia" } ,
	{ 0x1101, "Initio", "Initio Corporation" } ,
	{ 0x1102, "Creative Labs", "Creative Labs" } ,
	{ 0x1103, "Triones", "Triones Technologies Inc." } ,
	{ 0x1104, "Rasterops", "Rasterops" } ,
	{ 0x1105, "Sigma", "Sigma Designs Inc." } ,
	{ 0x1106, "Via", "Via Technologies" } ,
	{ 0x1107, "Stratus", "Stratus Computer" } ,
	{ 0x1108, "Proteon", "Proteon Inc." } ,
	{ 0x1109, "Cogent", "Cogent Data Technologies" } ,
	{ 0x110A, "Siemens", "Siemens AG / Siemens Nixdorf AG" } ,
	{ 0x110B, "Chromatic", "Chromatic Research Inc" } ,
	{ 0x110C, "Mini-Max", "Mini-Max Technology Inc." } ,
	{ 0x110D, "ZNYX", "ZNYX Corporation" } ,
	{ 0x110E, "CPU Tech.", "CPU Technology" } ,
	{ 0x110F, "Ross", "Ross Technology" } ,
	{ 0x1110, "Powerhouse", "Powerhouse Systems" } ,
	{ 0x1111, "SCO", "Santa Cruz Operation" } ,
	{ 0x1112, "Osicom", "Osicom Technologies, Inc." } ,
	{ 0x1113, "Accton", "Accton Technology Corporation" } ,
	{ 0x1114, "Atmel", "Atmel Corp." } ,
	{ 0x1115, "Dupont", "Dupont Pixel Systems Ltd." } ,
	{ 0x1116, "Data Trans.", "Data Translation" } ,
	{ 0x1117, "Datacube", "Datacube Inc." } ,
	{ 0x1118, "Berg", "Berg Electronics" } ,
	{ 0x1119, "Vortex", "Vortex Computersysteme GmbH" } ,
	{ 0x111A, "Eff. Net.", "Efficent Networks" } ,
	{ 0x111B, "Teledyne", "Teledyne Electronic Systems" } ,
	{ 0x111C, "Tricord", "Tricord Systems Inc." } ,
	{ 0x111D, "IDT", "Integrated Device Technology, Inc." } ,
	{ 0x111E, "Eldec", "Eldec Corp." } ,
	{ 0x111F, "PDI", "Precision Digital Images" } ,
	{ 0x1120, "EMC", "EMC Corp." } ,
	{ 0x1121, "Zilog", "Zilog" } ,
	{ 0x1122, "Multi-Tech", "Multi-Tech Systems Inc." } ,
	{ 0x1123, "EDI", "Excellent Design, Inc." } ,
	{ 0x1124, "Leutron", "Leutron Vision AG" } ,
	{ 0x1125, "Eurocore", "Eurocore/Vigra" } ,
	{ 0x1126, "Vigra", "Vigra" } ,
	{ 0x1127, "FORE", "FORE Systems" } ,
	{ 0x1129, "Firmworks", "Firmworks" } ,
	{ 0x112A, "Hermes", "Hermes Electronics Co. Ltd." } ,
	{ 0x112B, "Linotype", "Linotype - Hell AG" } ,
	{ 0x112C, "Zenith", "Zenith Data Systems" } ,
	{ 0x112D, "Ravicad", "Ravicad" } ,
	{ 0x112E, "Infomedia", "Infomedia" } ,
	{ 0x112F, "ImagTech", "Imaging Technology" } ,
	{ 0x1130, "Computervision", "Computervision" } ,
	{ 0x1131, "Philips", "Philips Semiconductors" } ,
	{ 0x1132, "Mitel", "Mitel Corp." } ,
	{ 0x1133, "EIC", "Eicon Technology Corporation" } ,
	{ 0x1134, "MCS", "Mercury Computer Systems, Inc." } ,
	{ 0x1135, "Fuji", "Fuji Xerox Co Ltd" } ,
	{ 0x1136, "Momentum", "Momentum Data Systems" } ,
	{ 0x1137, "Cisco", "Cisco Systems Inc" } ,
	{ 0x1138, "Ziatech", "Ziatech Corporation" } ,
	{ 0x1139, "Dyn. Pict.", "Dynamic Pictures Inc" } ,
	{ 0x113A, "FWB", "FWB  Inc" } ,
	{ 0x113B, "NCD", "Network Computing Devices" } ,
	{ 0x113C, "Cyclone", "Cyclone Microsystems" } ,
	{ 0x113D, "Leading Edge", "Leading Edge Products Inc" } ,
	{ 0x113E, "Sanyo", "Sanyo Electric Co" } ,
	{ 0x113F, "Equinox", "Equinox Systems" } ,
	{ 0x1140, "Intervoice", "Intervoice Inc" } ,
	{ 0x1141, "Crest", "Crest Microsystem Inc" } ,
	{ 0x1142, "Alliance", "Alliance Semiconductor" } ,
	{ 0x1143, "Netpower", "Netpower Inc" } ,
	{ 0x1144, "Cinn. Mil.", "Cincinnati Milacron" } ,
	{ 0x1145, "Workbit", "Workbit Corp" } ,
	{ 0x1146, "Force", "Force Computers" } ,
	{ 0x1147, "Interface", "Interface Corp" } ,
	{ 0x1148, "S&K", "Schneider & Koch" } ,
	{ 0x1149, "Win System", "Win System Corporation" } ,
	{ 0x114A, "VMIC", "VMIC" } ,
	{ 0x114B, "Canopus", "Canopus Co. Ltd" } ,
	{ 0x114C, "Annabooks", "Annabooks" } ,
	{ 0x114D, "IC Corp.", "IC Corporation" } ,
	{ 0x114E, "Nikon", "Nikon Systems Inc" } ,
	{ 0x114F, "Stargate", "Stargate" } ,
	{ 0x1150, "TMC", "Thinking Machines Corporation" } ,
	{ 0x1151, "JAE", "JAE Electronics Inc." } ,
	{ 0x1152, "Megatek", "Megatek" } ,
	{ 0x1153, "Land Win", "Land Win Electronic Corp" } ,
	{ 0x1154, "Melco", "Melco Inc" } ,
	{ 0x1155, "Pine", "Pine Technology Ltd" } ,
	{ 0x1156, "Periscope", "Periscope Engineering" } ,
	{ 0x1157, "Avsys", "Avsys Corporation" } ,
	{ 0x1158, "Voarx", "Voarx R&D Inc" } ,
	{ 0x1159, "Mutech", "Mutech" } ,
	{ 0x115A, "Harlequin", "Harlequin Ltd" } ,
	{ 0x115B, "Parallax", "Parallax Graphics" } ,
	{ 0x115C, "Photron", "Photron Ltd." } ,
	{ 0x115D, "Xircom", "Xircom" } ,
	{ 0x115E, "Peer", "Peer Protocols Inc" } ,
	{ 0x115F, "Maxtor", "Maxtor Corporation" } ,
	{ 0x1160, "Megasoft", "Megasoft Inc" } ,
	{ 0x1161, "PFU", "PFU Ltd" } ,
	{ 0x1162, "OA Lab", "OA Laboratory Co Ltd" } ,
	{ 0x1163, "Rendition", "Rendition Inc" } ,
	{ 0x1164, "APT", "Advanced Peripherals Tech" } ,
	{ 0x1165, "Imagraph", "Imagraph Corporation" } ,
	{ 0x1166, "Pequr", "Pequr Technology Inc." } ,
	{ 0x1167, "Mutoh", "Mutoh Industries Inc" } ,
	{ 0x1168, "Thine", "Thine Electronics Inc" } ,
	{ 0x116A, "Polaris", "Polaris Communications" } ,
	{ 0x116B, "Connectware", "Connectware Inc" } ,
	{ 0x116C, "Int Res.", "Intelligent Resources" } ,
	{ 0x116E, "EFI", "Electronics for Imaging" } ,
	{ 0x116F, "WkSta. Tech.", "Workstation Technology" } ,
	{ 0x1170, "Inventec", "Inventec Corporation" } ,
	{ 0x1171, "Lough. Sound", "Loughborough Sound Images" } ,
	{ 0x1172, "Altera", "Altera Corporation" } ,
	{ 0x1173, "Adobe", "Adobe Systems" } ,
	{ 0x1174, "Bridgeport", "Bridgeport Machines" } ,
	{ 0x1175, "Mitron", "Mitron Computer Inc." } ,
	{ 0x1176, "SBE", "SBE" } ,
	{ 0x1177, "Silicon Eng.", "Silicon Engineering" } ,
	{ 0x1178, "Alfa", "Alfa Inc" } ,
	{ 0x1179, "Toshiba", "Toshiba America Info Systems" } ,
	{ 0x117A, "A-Trend", "A-Trend Technology" } ,
	{ 0x117C, "Atto", "Atto Technology" } ,
	{ 0x117D, "B&D", "Becton & Dickinson" } ,
	{ 0x117E, "T/R", "T/R Systems" } ,
	{ 0x117F, "ICS", "Integrated Circuit Systems" } ,
	{ 0x1180, "Ricoh", "Ricoh Co Ltd" } ,
	{ 0x1181, "Telmatics", "Telmatics International" } ,
	{ 0x1183, "Fujikura", "Fujikura Ltd" } ,
	{ 0x1184, "Forks", "Forks Inc" } ,
	{ 0x1185, "Dataworld", "Dataworld" } ,
	{ 0x1186, "D-Link", "D-Link System Inc" } ,
	{ 0x1187, "ATL", "Advanced Technology Laboratories" } ,
	{ 0x1188, "Shima", "Shima Seiki Manufacturing Ltd." } ,
	{ 0x1189, "Matsushita", "Matsushita Electronics" } ,
	{ 0x118A, "Hilevel", "Hilevel Technology" } ,
	{ 0x118B, "Hypertec", "Hypertec Pty Ltd" } ,
	{ 0x118C, "Corollary", "Corollary Inc" } ,
	{ 0x118D, "BitFlow", "BitFlow Inc" } ,
	{ 0x118E, "Hermstedt", "Hermstedt GmbH" } ,
	{ 0x118F, "Green", "Green Logic" } ,
	{ 0x1191, "Artop", "Artop Electric" } ,
	{ 0x1192, "Densan", "Densan Co. Ltd" } ,
	{ 0x1193, "Zeitnet", "Zeitnet Inc." } ,
	{ 0x1194, "Toucan", "Toucan Technology" } ,
	{ 0x1195, "Ratoc", "Ratoc System Inc" } ,
	{ 0x1196, "Hytec", "Hytec Electronics Ltd" } ,
	{ 0x1197, "Gage", "Gage Applied Sciences Inc." } ,
	{ 0x1198, "Lambda", "Lambda Systems Inc" } ,
	{ 0x1199, "DCA", "Digital Communications Associates Inc, " } ,
	{ 0x119A, "Mind Share", "Mind Share Inc." } ,
	{ 0x119B, "Omega", "Omega Micro Inc." } ,
	{ 0x119C, "ITI", "Information Technology Inst." } ,
	{ 0x119D, "Bug", "Bug Sapporo Japan" } ,
	{ 0x119E, "Fujitsu", "Fujitsu" } ,
	{ 0x119F, "Bull", "Bull Hn Information Systems" } ,
	{ 0x11A0, "Convex", "Convex Computer Corporation" } ,
	{ 0x11A1, "Hamamatsu", "Hamamatsu Photonics K.K." } ,
	{ 0x11A2, "Sierra", "Sierra Research and Technology" } ,
	{ 0x11A4, "Barco", "Barco" } ,
	{ 0x11A5, "MicroUnity", "MicroUnity Systems Engineering, Inc." } ,
	{ 0x11A6, "Pure Data", "Pure Data" } ,
	{ 0x11A7, "Power Comp.", "Power Computing Corp." } ,
	{ 0x11A8, "Systech", "Systech Corp." } ,
	{ 0x11A9, "InnoSys", "InnoSys Inc." } ,
	{ 0x11AA, "Actel", "Actel" } ,
	{ 0x11AB, "Galileo", "Galileo Technology Ltd." } ,
	{ 0x11AC, "Canon", "Canon Information Systems" } ,
	{ 0x11AD, "Lite-On", "Lite-On Communications Inc" } ,
	{ 0x11AE, "Scitex", "Scitex Corporation Ltd" } ,
	{ 0x11AF, "Pro-Log", "Pro-Log Corporation" } ,
	{ 0x11B0, "V3", "V3 Semiconductor Inc." } ,
	{ 0x11B1, "Apricot", "Apricot Computers" } ,
	{ 0x11B2, "Kodak", "Eastman Kodak" } ,
	{ 0x11B3, "Barr", "Barr Systems Inc." } ,
	{ 0x11B4, "Leitch", "Leitch Technology International" } ,
	{ 0x11B5, "Radstone", "Radstone Technology Plc" } ,
	{ 0x11B6, "United Video", "United Video Corp" } ,
	{ 0x11B7, "Motorola", "Motorola" } ,
	{ 0x11B8, "Xpoint", "Xpoint Technologies Inc" } ,
	{ 0x11B9, "Pathlight", "Pathlight Technology Inc." } ,
	{ 0x11BA, "Videotron", "Videotron Corp" } ,
	{ 0x11BB, "Pyramid", "Pyramid Technology" } ,
	{ 0x11BC, "Net. Periph.", "Network Peripherals Inc" } ,
	{ 0x11BD, "Pinnacle", "Pinnacle Systems Inc." } ,
	{ 0x11BE, "IMI", "International Microcircuits Inc" } ,
	{ 0x11BF, "Astrodesign", "Astrodesign Inc." } ,
	{ 0x11C0, "H-P", "Hewlett-Packard" } ,
	{ 0x11C1, "AT&T", "AT&T Microelectronics" } ,
	{ 0x11C2, "Sand", "Sand Microelectronics" } ,
	{ 0x11C3, "NEC", "NEC Corporation" } ,
	{ 0x11C4, "Doc. Tech.", "Document Technologies Ind." } ,
	{ 0x11C5, "Shiva", "Shiva Corporatin" } ,
	{ 0x11C6, "Dainippon", "Dainippon Screen Mfg. Co" } ,
	{ 0x11C7, "D.C.M.", "D.C.M. Data Systems" } ,
	{ 0x11C8, "Dolphin", "Dolphin Interconnect Solutions" } ,
	{ 0x11C9, "MAGMA", "MAGMA" } ,
	{ 0x11CA, "LSI Sys.", "LSI Systems Inc" } ,
	{ 0x11CB, "Specialix", "Specialix Research Ltd." } ,
	{ 0x11CC, "M&K", "Michels & Kleberhoff Computer GmbH" } ,
	{ 0x11CD, "HAL", "HAL Computer Systems Inc." } ,
	{ 0x11CE, "PRI", "Primary Rate Inc" } ,
	{ 0x11CF, "PEC", "Pioneer Electronic Corporation" } ,
	{ 0x11D0, "Loral", "Loral Frederal Systems - Manassas" } ,
	{ 0x11D1, "AuraVision", "AuraVision Corporation" } ,
	{ 0x11D2, "Intercom", "Intercom Inc." } ,
	{ 0x11D3, "Trancell", "Trancell Systems Inc" } ,
	{ 0x11D4, "AD", "Analog Devices" } ,
	{ 0x11D5, "Ikon", "Ikon Corp" } ,
	{ 0x11D6, "Tekelec", "Tekelec Technologies" } ,
	{ 0x11D7, "Trenton", "Trenton Terminals Inc" } ,
	{ 0x11D8, "ITD", "Image Technologies Development" } ,
	{ 0x11D9, "Tec", "Tec Corporation" } ,
	{ 0x11DA, "Novell", "Novell" } ,
	{ 0x11DB, "Sega", "Sega Enterprises Ltd" } ,
	{ 0x11DC, "Questra", "Questra Corp" } ,
	{ 0x11DD, "Crosfield", "Crosfield Electronics Ltd" } ,
	{ 0x11DE, "Zoran", "Zoran Corporation" } ,
	{ 0x11DF, "New Wave", "New Wave Pdg" } ,
	{ 0x11E0, "Cray", "Cray Communications A/S" } ,
	{ 0x11E1, "Gec Plessey", "Gec Plessey Semi Inc" } ,
	{ 0x11E2, "Samsung", "Samsung Information Systems America" } ,
	{ 0x11E3, "Quicklogic", "Quicklogic Corp" } ,
	{ 0x11E4, "Second Wave", "Second Wave Inc" } ,
	{ 0x11E5, "IIX", "IIX Consulting" } ,
	{ 0x11E6, "Mitsui", "Mitsui-Zosen System Research" } ,
	{ 0x11E7, "Toshiba", "Toshiba America, Elec. Co" } ,
	{ 0x11E8, "DPSI", "Digital Processing Systems Inc" } ,
	{ 0x11E9, "Highwater", "Highwater Designs Ltd" } ,
	{ 0x11EA, "Elsag", "Elsag Bailey" } ,
	{ 0x11EB, "Formation", "Formation Inc" } ,
	{ 0x11EC, "Coreco", "Coreco Inc" } ,
	{ 0x11ED, "Mediamatics", "Mediamatics" } ,
	{ 0x11EE, "Dome", "Dome Imaging Systems Inc" } ,
	{ 0x11EF, "Nicolet", "Nicolet Technologies BV" } ,
	{ 0x11F0, "Compu-Shack", "Compu-Shack GmbH" } ,
	{ 0x11F1, "Symbios", "Symbios Logic Inc" } ,
	{ 0x11F2, "Pic-Tel", "Picture Tel Japan KK" } ,
	{ 0x11F3, "Keithley", "Keithley Metrabyte" } ,
	{ 0x11F4, "Kinetic", "Kinetic Systems Corporation" } ,
	{ 0x11F5, "Comp Dev", "Computing Devices Intl" } ,
	{ 0x11F6, "Powermatic", "Powermatic Data Systems Ltd" } ,
	{ 0x11F7, "S-A", "Scientific Atlanta" } ,
	{ 0x11F8, "PMC-Sierra", "PMC-Sierra Inc." } ,
	{ 0x11F9, "I-Cube", "I-Cube Inc" } ,
	{ 0x11FA, "Kasan", "Kasan Electronics Co Ltd" } ,
	{ 0x11FB, "Datel", "Datel Inc" } ,
	{ 0x11FC, "Silicon Magic", "Silicon Magic" } ,
	{ 0x11FD, "High Street", "High Street Consultants" } ,
	{ 0x11FE, "Comtrol", "Comtrol Corp" } ,
	{ 0x11FF, "Scion", "Scion Corp" } ,
	{ 0x1200, "CSS", "CSS Corp" } ,
	{ 0x1201, "Vista", "Vista Controls Corp" } ,
	{ 0x1202, "Network Gen", "Network General Corp" } ,
	{ 0x1203, "Agfa", "Bayer Corporation, Agfa Div" } ,
	{ 0x1204, "Lattice", "Lattice Semiconductor Corp" } ,
	{ 0x1205, "Array", "Array Corp" } ,
	{ 0x1206, "Amdahl", "Amdahl Corp" } ,
	{ 0x1208, "Parsytec", "Parsytec GmbH" } ,
	{ 0x1209, "Sci Sys", "Sci Systems Inc" } ,
	{ 0x120A, "Synaptel", "Synaptel" } ,
	{ 0x120B, "Adaptive", "Adaptive Solutions" } ,
	{ 0x120D, "Comp Labs", "Compression Labs, Inc." } ,
	{ 0x120E, "Cyclades", "Cyclades Corporation" } ,
	{ 0x120F, "Essential", "Essential Communications" } ,
	{ 0x1210, "Hyperparallel", "Hyperparallel Technologies" } ,
	{ 0x1211, "Braintech", "Braintech Inc" } ,
	{ 0x1212, "Kingston", "Kingston Technology Corp" } ,
	{ 0x1213, "AISI", "Applied Intelligent Systems Inc" } ,
	{ 0x1214, "Perf Tech", "Performance Technologies Inc" } ,
	{ 0x1215, "Interware", "Interware Co Ltd" } ,
	{ 0x1216, "Purup", "Purup Prepress A/S" } ,
	{ 0x1217, "2 Micro", "2 Micro Inc" } ,
	{ 0x1218, "Hybricon", "Hybricon Corp" } ,
	{ 0x1219, "First Virtual", "First Virtual Corp" } ,
	{ 0x121A, "3dfx", "3dfx Interactive Inc" } ,
	{ 0x121B, "ATM", "Advanced Telecommunications Modules" } ,
	{ 0x121C, "Nippon Texa", "Nippon Texa Co Ltd" } ,
	{ 0x121D, "Lippert", "Lippert Automationstechnik GmbH" } ,
	{ 0x121E, "CSPI", "CSPI" } ,
	{ 0x121F, "Arcus", "Arcus Technology Inc" } ,
	{ 0x1220, "Ariel", "Ariel Corporation" } ,
	{ 0x1221, "Contec", "Contec Co Ltd" } ,
	{ 0x1222, "Ancor", "Ancor Communications Inc" } ,
	{ 0x1223, "Heurikon", "Heurikon/Computer Products" } ,
	{ 0x122C, "Sican", "Sican GmbH" } ,
	{ 0x122D, "Aztech", "Aztech System Ltd" } ,
	{ 0x1234, "Technical", "Technical Corp" } ,
	{ 0x1239, "3DO", "The 3DO Company" } ,
	{ 0x1246, "Dipix", "Dipix Technologies Inc" } ,
	{ 0x124B, "GreenSpring", "GreenSpring Computers" } ,
	{ 0x124D, "Stallion", "Stallion Technologies" } ,
	{ 0x124F, "Infortrend", "Infortrend Technology Inc" } ,
	{ 0x1254, "Linear Systems", "Linear Systems Ltd." } ,
	{ 0x125C, "Aurora", "Aurora Technologies, Inc." } ,
	{ 0x126F, "Sil Motion", "Silicon Motion" } ,
	{ 0x1275, "NetApp", "Network Appliance" } ,
	{ 0x1278, "Transtech", "Transtech Parallel Systems" } ,
	{ 0x127A, "Rockwell Intl", "Rockwell Semiconductor Systems" } ,
	{ 0x127B, "Pixera", "Pixera Corp" } ,
	{ 0x1296, "Kofax", "Kofax Image Products" } ,
	{ 0x1297, "Holco", "Holco Enterprise" } ,
	{ 0x12A1, "Simpact", "Simpact Inc" } ,
	{ 0x12BA, "Bittware", "Bittware Research Systems Inc" } ,
	{ 0x12C2, "Mentec", "Mentec Ltd." } ,
	{ 0x12C5, "PicturEl", "Picture Elements, Inc." } ,
	{ 0x12DD, "MGI", "Management Graphics Inc." } ,
	{ 0x12E7, "Sebring", "Sebring Systems Inc" } ,
	{ 0x12EB, "Aureal", "Aureal Semiconductor" } ,
	{ 0x12F9, "FFT", "FourFold Technologies" } ,
	{ 0x1C1C, "Symphony", "Symphony" } ,
	{ 0x1DE1, "Tekram", "Tekram" } ,
	{ 0x3000, "Hansol", "Hansol Electronics Inc." } ,
	{ 0x3D3D, "3DLabs", "3DLabs" } ,
	{ 0x4005, "Avance", "Avance Logic Inc." } ,
	{ 0x4B10, "Buslogic", "Buslogic Inc" } ,
	{ 0x5333, "S3", "S3 Incorporated" } ,
	{ 0x5700, "Netpower", "Netpower" } ,
	{ 0x6374, "C4T", "c't Magazin fr Computertechnik" } ,
	{ 0x8008, "Quancom", "Quancm Electronic GmbH" } ,
	{ 0x8086, "Intel", "Intel Corporation" } ,
	{ 0x8800, "Trigem", "Trigem Computer" } ,
	{ 0x8E0E, "Computone", "Computone Corporation" } ,
	{ 0x9004, "Adaptec", "Adaptec" } ,
	{ 0x907F, "Atronics", "Atronics" } ,
	{ 0xE159, "Tiger Jet", "Tiger Jet Network Inc" } ,
	{ 0xEDD8, "ARC", "ARC Logic" } ,
	{ 0xFFFF, "BAD!", "ILLEGITIMATE VENDOR ID" } ,
} ;

typedef struct _PCI_DEVTABLE
{
	unsigned short	VenId ;
	unsigned short	DevId ;
	char *	Chip ;
	char *	ChipDesc ;
}  PCI_DEVTABLE, *PPCI_DEVTABLE ;

PCI_DEVTABLE	PciDevTable [] =
{
	{ 0x0E11, 0x0001, "EISA Bridge", "" } ,
	{ 0x0E11, 0x0002, "ISA Bridge", "" } ,
	{ 0x0E11, 0x1000, "", "Triflex/PCI CPU Bridge" } ,
	{ 0x0E11, 0x2000, "", "Triflex/PCI CPU Bridge" } ,
	{ 0x0E11, 0x3032, "QVision", "GUI Accelerator v0" } ,
	{ 0x0E11, 0x3033, "QVision", "GUI Accelerator v1" } ,
	{ 0x0E11, 0x3034, "QVision", "GUI Accelerator v2" } ,
	{ 0x0E11, 0x4000, "4000", "Triflex/PCI CPU Bridge" } ,
	{ 0x1000, 0x0001, "53C810", "Fast/Narrow SCSI I/O Cntrlr" } ,
	{ 0x1000, 0x0002, "53C820", "Fast-wide SCSI" } ,
	{ 0x1000, 0x0003, "53C825", "Fast-wide SCSI" } ,
	{ 0x1000, 0x0004, "53C815", "Fast SCSI" } ,
	{ 0x1000, 0x0006, "53C860", "Ultra SCSI/Narrow" } ,
	{ 0x1000, 0x000F, "53C875", "Ultra-Wide SCSI" } ,
	{ 0x1002, 0x4158, "68800", "Mach 32" } ,
	{ 0x1002, 0x4354, "215CT222", "" } ,
	{ 0x1002, 0x4358, "210888CX", "" } ,
	{ 0x1002, 0x4758, "210888GX", "Mach 64 (WinTurbo)" } ,
	{ 0x1002, 0x5654, "215VT222", "VIDEO XPRESSION" } ,
	{ 0x1003, 0x0201, "US201", "Graphics Cntrlr" } ,
	{ 0x1004, 0x0005, "82C591", "CPU Bridge" } ,
	{ 0x1004, 0x0006, "82C593", "ISA Bridge" } ,
	{ 0x1004, 0x0007, "82C594", "Wildcat System Controller" } ,
	{ 0x1004, 0x0008, "82C596/597", "Wildcat ISA Bridge" } ,
	{ 0x1004, 0x000C, "82C541", "" } ,
	{ 0x1004, 0x000D, "82C543", "" } ,
	{ 0x1004, 0x0101, "82C532", "" } ,
	{ 0x1004, 0x0102, "82C534", "" } ,
	{ 0x1004, 0x0104, "82C535", "" } ,
	{ 0x1004, 0x0105, "82C147", "" } ,
	{ 0x1004, 0x0200, "82C975", "RISC GUI Accelerator" } ,
	{ 0x1004, 0x0280, "82C925", "RISC GUI Accelerator" } ,
	{ 0x1005, 0x2301, "AVL2301", "GUI Accelerator" } ,
	{ 0x1005, 0x2302, "AVG2302", "GUI Accelerator" } ,
	{ 0x100B, 0x0001, "DP83810", "10/100 Ethernet MAC" } ,
	{ 0x100B, 0xD001, "87410", "EIDE Ctrlr" } ,
	{ 0x100C, 0x3202, "ET4000W32P-A", "GUI Accelerator" } ,
	{ 0x100C, 0x3205, "ET4000W32P-B", "GUI Accelerator" } ,
	{ 0x100C, 0x3206, "ET4000W32P-C", "GUI Accelerator" } ,
	{ 0x100C, 0x3207, "ET4000W32P-D", "GUI Accelerator" } ,
	{ 0x100C, 0x3208, "ET6000", "Graphics/Multimedia Engine" } ,
	{ 0x100E, 0x9001, "P9000", "GUI Accelerator" } ,
	{ 0x100E, 0x9100, "P9100", "GUI Accelerator" } ,
	{ 0x1011, 0x0001, "DC21050", "PCI-PCI Bridge" } ,
	{ 0x1011, 0x0002, "DC21040", "Ethernet Ctrlr" } ,
	{ 0x1011, 0x0009, "DC21140", "Fast Ethernet Ctrlr" } ,
	{ 0x1011, 0x000F, "DEFPA", "FDDI" } ,
	{ 0x1011, 0x0014, "DC21041", "Ethernet Ctrlr" } ,
	{ 0x1011, 0x0016, "DGLPB", "ATM" } ,
	{ 0x1011, 0x0019, "DC21143", "PCI/CardBus 10/100 Mbit Ethernet Ctlr" } ,
	{ 0x1011, 0x0021, "21052", "PCI-PCI Bridge" } ,
	{ 0x1011, 0x0022, "21150", "PCI-PCI Bridge" } ,
	{ 0x1011, 0x0024, "21152", "PCI-PCI Bridge" } ,
	{ 0x1011, 0x0025, "21153", "PCI-PCI Bridge" } ,
	{ 0x1011, 0x0026, "21154", "PCI-PCI Bridge" } ,
	{ 0x1013, 0x00A0, "GD 5340", "GUI Accelerator" } ,
	{ 0x1013, 0x00A4, "GD 5434", "GUI Accelerator" } ,
	{ 0x1013, 0x00A8, "GD 5434-HC-B", "GUI Accelerator" } ,
	{ 0x1013, 0x00B8, "GD5446", "Visual Media Accelerator (64bit)" } ,
	{ 0x1013, 0x1100, "CL 6729", "PCMCIA Bridge" } ,
	{ 0x1013, 0x1200, "7542", "GUI Accelerator" } ,
	{ 0x1013, 0x1202, "7543", "GUI Accelerator" } ,
	{ 0x1013, 0x1204, "7541", "Nordic-lite VGA Cntrlr " } ,
	{ 0x1014, 0x0002, "MCA Bridge", "MCA Bridge" } ,
	{ 0x1014, 0x0005, "Alta Lite", "CPU Bridge" } ,
	{ 0x1014, 0x0007, "Alta MP", "CPU Bridge" } ,
	{ 0x1014, 0x000A, "ISA Bridge w/PnP", "ISA Bridge w/PnP" } ,
	{ 0x1014, 0x0017, "CPU Bridge", "CPU Bridge" } ,
	{ 0x1014, 0x0018, "Auto LANStreamer", "" } ,
	{ 0x1014, 0x001B, "GXT-150P", "Graphics Adapter" } ,
	{ 0x1014, 0x0020, "", "MCA Bridge" } ,
	{ 0x1014, 0x0022, "PCI-PCI BRIDGE", "PCI-PCI BRIDGE" } ,
	{ 0x1014, 0x0036, "Miami/PCI", "32-bit LocalBus Bridge" } ,
	{ 0x101C, 0x0193, "WD33C193A", "8-bit SCSI Cntrlr" } ,
	{ 0x101C, 0x0196, "SCSI Bridge", "SCSI Bridge" } ,
	{ 0x101C, 0x0197, "WD33C197A", "16-bit SCSI Cntrlr" } ,
	{ 0x101C, 0x0296, "WD33C296A", "high perf 16-bit SCSI Cntrlr" } ,
	{ 0x101C, 0x3193, "WD7193", "Fast SCSI-II" } ,
	{ 0x101C, 0x3197, "WD7197", "Fast-wide SCSI-II" } ,
	{ 0x101C, 0x3296, "WD33C296A", "Fast Wide SCSI bridge" } ,
	{ 0x101C, 0x4296, "WD34C296", "Wide Fast-20 Bridge" } ,
	{ 0x101C, 0xC24A, "90C", "" } ,
	{ 0x101E, 0x9010, "MegaRAID", "Fast-wide SCSI/RAID" } ,
	{ 0x101E, 0x9030, "", "IDE Cntrlr" } ,
	{ 0x101E, 0x9031, "", "IDE Cntrlr" } ,
	{ 0x101E, 0x9032, "", "IDE and SCSI Cntrlr" } ,
	{ 0x101E, 0x9033, "", "SCSI Cntrlr" } ,
	{ 0x101E, 0x9040, "", "Multimedia card" } ,
	{ 0x1022, 0x2000, "79C970", "Ethernet Ctrlr" } ,
	{ 0x1022, 0x2020, "53C974", "SCSI Ctrlr" } ,
	{ 0x1022, 0x2040, "79C974", "Ethernet & SCSI Ctrlr" } ,
	{ 0x1023, 0x9320, "", "32-bit GUI Accelerator" } ,
	{ 0x1023, 0x9350, "", "32-bit GUI Accelerator" } ,
	{ 0x1023, 0x9360, "", "Flat panel Cntrlr" } ,
	{ 0x1023, 0x9420, "9420", "VGA Ctrlr" } ,
	{ 0x1023, 0x9440, "9440", "" } ,
	{ 0x1023, 0x9460, "", "32-bit GUI Accelerator" } ,
	{ 0x1023, 0x9660, "9660", "" } ,
	{ 0x1023, 0x9682, "", "Multimedia Accelerator" } ,
	{ 0x1025, 0x1435, "M1435", "VL Bridge" } ,
	{ 0x1025, 0x1445, "M1445", "VL Bridge & EIDE" } ,
	{ 0x1025, 0x1449, "M1449", "ISA Bridge" } ,
	{ 0x1025, 0x1451, "M1451", "Pentium Chipset" } ,
	{ 0x1025, 0x1461, "M1461", "P54C Chipset" } ,
	{ 0x1025, 0x3141, "M3141", "GUI Accelerator, 2 MB VRAM" } ,
	{ 0x1025, 0x3143, "M3143", "GUI Accelerator, 2 MB VRAM w/DAC" } ,
	{ 0x1025, 0x3145, "M3145", "GUI Accelerator, 2 MB VRAM, " } ,
	{ 0x1025, 0x3147, "M3147", "GUI Accelerator, 2 MB VRAM w/DAC" } ,
	{ 0x1025, 0x3149, "M3149", "GUI Accelerator, 4 MB VRAM" } ,
	{ 0x1025, 0x3151, "M3151", "GUI Accelerator, 8 MB VRAM" } ,
	{ 0x1025, 0x5215, "?", "EIDE Ctrlr" } ,
	{ 0x102A, 0x0000, "HYDRA", "P5 Chipset" } ,
	{ 0x102A, 0x0010, "ASPEN", "i486 Chipset" } ,
	{ 0x102B, 0x0518, "Atlas PX2085", "GUI Accelerator" } ,
	{ 0x102B, 0x0519, "2064W", "Millenium GUI Accelerator" } ,
	{ 0x102B, 0x051A, "MGA 1064SG", "64-bit graphics chip" } ,
	{ 0x102B, 0x0D10, "Impression", "GUI Accelerator" } ,
	{ 0x102C, 0x00B8, "64310", "GUI Accelerator" } ,
	{ 0x102C, 0x00D0, "65545", "Flat panel/crt VGA Cntrlr" } ,
	{ 0x102C, 0x00D8, "65545", "GUI Accelerator" } ,
	{ 0x102C, 0x00DC, "65548", "GUI Accelerator" } ,
	{ 0x102C, 0x00E0, "65550", "LCD/CRT controller" } ,
	{ 0x102C, 0x00E4, "65554", "Display" } ,
	{ 0x102F, 0x0009, "", "r4x00 Bridge" } ,
	{ 0x1031, 0x5607, "", "video in and out with motion jpeg compr" } ,
	{ 0x1033, 0x0001, "", "PCI to 486 like bus Bridge" } ,
	{ 0x1033, 0x0002, "", "PCI to vl98 Bridge" } ,
	{ 0x1033, 0x0003, "", "atm lan Cntrlr" } ,
	{ 0x1033, 0x0004, "", "r4000PCI bus Bridge" } ,
	{ 0x1033, 0x0005, "", "PCI to 486 like peripheral bus Bridge" } ,
	{ 0x1033, 0x0006, "", "GUI Accelerator" } ,
	{ 0x1033, 0x0007, "", "PCI to ux-bus Bridge" } ,
	{ 0x1033, 0x0008, "", "GUI Accelerator (vga equivalent)" } ,
	{ 0x1033, 0x0009, "", "graphic Cntrlr for 98" } ,
	{ 0x1036, 0x0000, "TMC-18C30", "" } ,
	{ 0x1039, 0x0001, "86C201", "True-Color GUI Accelerator" } ,
	{ 0x1039, 0x0002, "", "VGA Cntrlr" } ,
	{ 0x1039, 0x0006, "85C501/2", "Pentium Bridge" } ,
	{ 0x1039, 0x0008, "85C503/5513", "ISA Bridge" } ,
	{ 0x1039, 0x0406, "85C501/2", "Pentium Bridge" } ,
	{ 0x1039, 0x0496, "85C496", "VL Bridge" } ,
	{ 0x1039, 0x0596, "", "p5 chipset w/DE" } ,
	{ 0x1039, 0x0601, "601", "EIDE Ctrlr" } ,
	{ 0x1039, 0x3602, "", "IDE Cntrlr" } ,
	{ 0x1039, 0x5401, "", "486 chipset" } ,
	{ 0x1039, 0x5511, "SiS5511/5512", "Pentium Chipset" } ,
	{ 0x1039, 0x5513, "SiS5513", "EIDE Ctrlr" } ,
	{ 0x1039, 0x5581, "", "p5 chipset" } ,
	{ 0x1039, 0x5582, "", "ISA Bridge" } ,
	{ 0x1039, 0x5596, "", "p5 chipset" } ,
	{ 0x1039, 0x6204, "", "video decoder/mpeg interface" } ,
	{ 0x1039, 0x6205, "", "PCI vga Cntrlr" } ,
	{ 0x103C, 0x1030, "J2585A", "" } ,
	{ 0x103C, 0x2910, "E2910A", "PCI Bus Exerciser" } ,
	{ 0x103C, 0x2925, "E2925A", "PCI Bus Exerciser" } ,
	{ 0x1042, 0x1000, "FDC 37C665", "EIDE" } ,
	{ 0x1042, 0x1000, "RZ1000", "IDE Ctrlr" } ,
	{ 0x1042, 0x1001, "37C922", "" } ,
	{ 0x1044, 0xA400, "2124A/9X", "SmartCache/Raid SCSI" } ,
	{ 0x1045, 0xC178, "92C178", "LCD GUI Accelerator" } ,
	{ 0x1045, 0xC557, "82C557", "CPU Bridge (Viper)" } ,
	{ 0x1045, 0xC558, "82C558", "ISA Bridge w/PnP" } ,
	{ 0x1045, 0xC621, "82C621", "VESA Bridge" } ,
	{ 0x1045, 0xC822, "82C822", "EIDE Ctrlr" } ,
	{ 0x104B, 0x0140, "BT-946C", "SCSI-II" } ,
	{ 0x104B, 0x1040, "BA80C30", "SCSI" } ,
	{ 0x104B, 0x8130, "Flashpoint LT", "Ultra SCSI" } ,
	{ 0x104C, 0x0500, "", "100 MBit LAN Cntrlr" } ,
	{ 0x104C, 0x0508, "", "tms380c2x compressor interface" } ,
	{ 0x104C, 0x1000, "TI PCI Eagle i/f AS", "" } ,
	{ 0x104C, 0xA001, "TDC1570", "64-bit PCI ATM sar" } ,
	{ 0x104C, 0xA100, "TDC1561", "32-bit PCI ATM sar" } ,
	{ 0x104C, 0xAC10, "PCI1050", "pc card Cntrlr" } ,
	{ 0x104C, 0xAC11, "PCI1053", "pc card Cntrlr" } ,
	{ 0x104C, 0xAC12, "PCI1130", "pc card Cardbus Cntrlr" } ,
	{ 0x104E, 0x0107, "OTI107", "Spitfire VGA Accelerator" } ,
	{ 0x1050, 0x0000, "", "Ethernet Cntrlr" } ,
	{ 0x1054, 0x0001, "", "PCI Bridge" } ,
	{ 0x1054, 0x0002, "", "PCI bus Cntrlr" } ,
	{ 0x1055, 0x0810, "", "486 host Bridge" } ,
	{ 0x1055, 0x0922, "", "Pentium/p54c host Bridge" } ,
	{ 0x1055, 0x0926, "", "ISA Bridge" } ,
	{ 0x1057, 0x0001, "MPC105", "PowerPC Chipset" } ,
	{ 0x1057, 0x0002, "MPC106", "PowerPC Chipset" } ,
	{ 0x105A, 0x5300, "DC5300", "" } ,
	{ 0x105D, 0x2309, "Imagine 128", "GUI Accelerator" } ,
	{ 0x105D, 0x2339, "I128s2", "Imagine 128 Series 2" } ,
	{ 0x105D, 0x493D, "T2R", "Imagine 128 3D" } ,
	{ 0x1060, 0x0001, "UM82C881", "486 Chipset" } ,
	{ 0x1060, 0x0002, "UM82C886", "ISA Bridge" } ,
	{ 0x1060, 0x0101, "UM8673F", "EIDE Controller" } ,
	{ 0x1060, 0x0881, "UM8881", "HB4 486 PCI Chipset" } ,
	{ 0x1060, 0x0881, "UM8881", "" } ,
	{ 0x1060, 0x0886, "UM8886F", "ISA Bridge" } ,
	{ 0x1060, 0x0891, "UM82C891", "Pentium Chipset" } ,
	{ 0x1060, 0x1001, "UM886A", "IDE Cntrlr (dual function)" } ,
	{ 0x1060, 0x673A, "UM8886", "Funktion 1: EIDE Controller" } ,
	{ 0x1060, 0x8710, "UM8710", "VGA Cntrlr" } ,
	{ 0x1060, 0x886A, "UM8886", "ISA Bridge with EIDE" } ,
	{ 0x1060, 0x8881, "UM8881F", "HB4 486 PCI Chipset" } ,
	{ 0x1060, 0x8886, "UM8886", "ISA Bridge" } ,
	{ 0x1060, 0x8891, "UM8891", "586 Chipset" } ,
	{ 0x1060, 0x9017, "UM9017F", "" } ,
	{ 0x1060, 0xE881, "UM8881", "486 Chipset" } ,
	{ 0x1060, 0xE886, "UM8886", "ISA Bridge w/EIDE" } ,
	{ 0x1060, 0xE891, "UM8891", "Pentium Chipset" } ,
	{ 0x1061, 0x0001, "AGX016", "GUI Accelerator" } ,
	{ 0x1061, 0x0002, "IIT3204/3501", "MPEG Decoder" } ,
	{ 0x1066, 0x0000, "PT80C826", "VL Bridge" } ,
	{ 0x1069, 0x0001, "DAC960P", "Wide SCSI w/RAID" } ,
	{ 0x1073, 0x0001, "", "3D graphics Cntrlr" } ,
	{ 0x1073, 0x0002, "YGV615", "RPA3 3D-Graphics Controller" } ,
	{ 0x1077, 0x1020, "ISP1020A", "Fast-wide SCSI" } ,
	{ 0x1077, 0x1022, "ISP1022A", "Fast-wide SCSI" } ,
	{ 0x107D, 0x0000, "P86C850", "Graphic GLU-Logic" } ,
	{ 0x107E, 0x0001, "", "ATM interface card" } ,
	{ 0x107E, 0x0002, "", "100 vg anylan Cntrlr" } ,
	{ 0x107F, 0x0802, "SL82C105", "EIDE Ctrlr" } ,
	{ 0x1080, 0x0600, "82C599", "VL Bridge" } ,
	{ 0x1083, 0x0001, "FR710", "EIDE Ctrlr" } ,
	{ 0x1083, 0x0613, "", "Host Bridge" } ,
	{ 0x108A, 0x0001, "Model 617", "PCI-VME Bus Adapter" } ,
	{ 0x108D, 0x0001, "", "Ethernet Ctrlr" } ,
	{ 0x1091, 0x0020, "", "3D Graphics Processor" } ,
	{ 0x1091, 0x0021, "", "3D graphics processor w/texturing" } ,
	{ 0x1091, 0x0040, "", "3D graphics frame buffer" } ,
	{ 0x1091, 0x0041, "", "3D graphics frame buffer" } ,
	{ 0x1091, 0x0060, "", "Proprietary bus Bridge" } ,
	{ 0x1091, 0x0720, "", "Motion JPEG Codec" } ,
	{ 0x1093, 0xC801, "PCI-GPIB", "GPIB Controller Interface Board" } ,
	{ 0x1095, 0x0640, "PCI0640A", "EIDE Ctrlr" } ,
	{ 0x1095, 0x0642, "", "IDE Cntrlr w/RAID 1" } ,
	{ 0x1095, 0x0646, "PCI0646", "EIDE Ctrlr" } ,
	{ 0x1095, 0x0650, "PBC0650A", "Fast SCSI-II Ctrlr" } ,
	{ 0x1097, 0x0038, "", "EIDE Ctrlr" } ,
	{ 0x1098, 0x0001, "QD-8500", "" } ,
	{ 0x1098, 0x0002, "QD-8580", "" } ,
	{ 0x109E, 0x0350, "BT848", "TV/PCI with DMA Push" } ,
	{ 0x109E, 0x2115, "BtV 2115", "BtV Mediastream Controller" } ,
	{ 0x109E, 0x2125, "BtV 2125", "BtV Mediastream Controller" } ,
	{ 0x109E, 0x8230, "?", "?" } ,
	{ 0x10A8, 0x0000, "?", "64-bit GUI Accelerator" } ,
	{ 0x10AA, 0x0000, "ACCM 2188 VL-PCI Br", "" } ,
	{ 0x10AD, 0x0001, "W83769F", "EIDE Ctrlr" } ,
	{ 0x10AD, 0x0103, "sl82c103", " PCI-ide mode 4.5 Cntrlr" } ,
	{ 0x10AD, 0x0105, "sl82c105", " - bus master PCI-ide mode 4.5 Cntrlr" } ,
	{ 0x10B5, 0x9036, "PCI9036", "Interface chip" } ,
	{ 0x10B5, 0x9050, "PCI 9050", "Target PCI Interface Chip" } ,
	{ 0x10B5, 0x9060, "PCI9060xx", "Interface chip" } ,
	{ 0x10B5, 0x9080, "PCI 9080", "High performance PCI to Local Bus chip" } ,
	{ 0x10B6, 0x0001, "Smart 16/4", "Ringnode" } ,
	{ 0x10B6, 0x1000, "Collage 25", "ATM adapter" } ,
	{ 0x10B6, 0x1001, "Collage 155", "ATM adapter" } ,
	{ 0x10B7, 0x5900, "3C590", "Ethernet 10bT" } ,
	{ 0x10B7, 0x5950, "3C595", "Ethernet 100bTX" } ,
	{ 0x10B7, 0x5951, "3C595", "Ethernet 100bT4" } ,
	{ 0x10B7, 0x5952, "3C595", "Ethernet 100b-MII" } ,
	{ 0x10B7, 0x8811, "", "Token Ring" } ,
	{ 0x10B7, 0x9000, "3C900-TPO", "Fast Etherlink XL PCI 10" } ,
	{ 0x10B7, 0x9001, "3C900-COMBO", "Fast Etherlink XL PCI 10" } ,
	{ 0x10B7, 0x9050, "3C905-TX", "Fast Etherlink XL PCI 10/100" } ,
	{ 0x10B8, 0x1000, "37C665", "FDC" } ,
	{ 0x10B8, 0x1001, "37C922", "FDC" } ,
	{ 0x10B9, 0x1435, "M1435", "VL Bridge" } ,
	{ 0x10B9, 0x1445, "M1445", "VL Bridge w/EIDE" } ,
	{ 0x10B9, 0x1449, "M1449", "ISA Bridge" } ,
	{ 0x10B9, 0x1451, "M1451", "Pentium Chipset" } ,
	{ 0x10B9, 0x1461, "M1461", "P54C Chipset" } ,
	{ 0x10B9, 0x3141, "M3141", "GUI Accelerator" } ,
	{ 0x10B9, 0x3143, "M3143", "GUI Accelerator" } ,
	{ 0x10B9, 0x3145, "M3145", "GUI Accelerator" } ,
	{ 0x10B9, 0x3147, "M3147", "GUI Accelerator" } ,
	{ 0x10B9, 0x3149, "M3149", "GUI Accelerator" } ,
	{ 0x10B9, 0x3151, "M3151", "GUI Accelerator" } ,
	{ 0x10B9, 0x5215, "MS4803", "EIDE Ctrlr" } ,
	{ 0x10B9, 0x5217, "m5217h", "I/O (?)" } ,
	{ 0x10B9, 0x5219, "m5219", "I/O (?)" } ,
	{ 0x10B9, 0x5235, "m5225", "I/O (?)" } ,
	{ 0x10BD, 0x5240, "", "IDE Cntrlr" } ,
	{ 0x10BD, 0x5241, "", "PCMCIA Bridge" } ,
	{ 0x10BD, 0x5242, "", "General Purpose Cntrlr" } ,
	{ 0x10BD, 0x5243, "", "Bus Cntrlr" } ,
	{ 0x10BD, 0x5244, "", "FCD Cntrlr" } ,
	{ 0x10C8, 0x0000, "", "Graphics Cntrlr" } ,
	{ 0x10CD, 0x1100, "", "SCSI I/O Cntrlr" } ,
	{ 0x10CD, 0x1200, "ASC1200", "Fast SCSI-II" } ,
	{ 0x10CD, 0x1300, "", "Fast-wide SCSI Cntrlr" } ,
	{ 0x10CF, 0x2001, "mb86605", "Wide SCSI-2" } ,
	{ 0x10DC, 0x0002, "ATT 2C15-3 (FPGA)", "SCI bridge  on PCI 5 Volt card" } ,
	{ 0x10DC, 0x10DC, "ATT 2C15-3 (FPGA)", "" } ,
	{ 0x10DD, 0x0001, "", "3D graphics processor" } ,
	{ 0x10DF, 0x1AE5, "", "Fibre Channel Host Adapter" } ,
	{ 0x10E0, 0x5026, "IMS5026/27/28", "VL Bridge" } ,
	{ 0x10E0, 0x5028, "", "ISA Bridge" } ,
	{ 0x10E0, 0x8849, "8849", "VL Bridge" } ,
	{ 0x10E0, 0x8853, "", "ATM network card" } ,
	{ 0x10E0, 0x9128, "IMS9129", "GUI Accelerator" } ,
	{ 0x10E3, 0x0000, "CA91C042", "VMEbus Bridge" } ,
	{ 0x10E8, 0x4750, "S5933", "PCI Ctrlr" } ,
	{ 0x10E8, 0x8043, "LANai4.x", "Myrinet LANai interface chip" } ,
	{ 0x10EB, 0x0101, "3GA", "64 bit graphics processor" } ,
	{ 0x10EC, 0x8029, "", "NE2000 compatible Ethernet" } ,
	{ 0x10ED, 0x7310, "V7310", "VGA Video Overlay Adapter" } ,
	{ 0x10F5, 0xA001, "NDR4000", "NR4600 Bridge" } ,
	{ 0x10FA, 0x0000, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0001, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0002, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0003, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0004, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0005, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0006, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0007, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0008, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0009, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0010, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0011, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0012, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0013, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0014, "", "GUI Accelerator" } ,
	{ 0x10FA, 0x0015, "", "GUI Accelerator" } ,
	{ 0x1101, 0x9100, "", "8-bit Fast-wide SCSI" } ,
	{ 0x1101, 0x9400, "", "Fast Wide SCSI" } ,
	{ 0x1101, 0x9700, "", "Fast Wide SCSI" } ,
	{ 0x1106, 0x0505, "82C505", "VL Bridge" } ,
	{ 0x1106, 0x0561, "82C561", "IDE" } ,
	{ 0x1106, 0x0576, "82C576", "P54 Ctrlr" } ,
	{ 0x1106, 0x0585, "VT82C585VP", "Host Bus-PCI Bridge" } ,
	{ 0x1106, 0x0586, "VT82C586VP", "PCI-ISA Bridge w/ IDE & USB" } ,
	{ 0x1106, 0x1000, "82C570MV", "P54 Ctrlr" } ,
	{ 0x1106, 0x1106, "82C570MV", "ISA Bridge w/IDE" } ,
	{ 0x1108, 0x0100, "p1690plus-AA", "Token Ring Adapter" } ,
	{ 0x1108, 0x0101, "p1690plus-AB", "2-Port Token Ring Adapter" } ,
	{ 0x1109, 0x1400, "EM110TX", "EX110TX PCI Fast Ethernet Adapter" } ,
	{ 0x110A, 0x6120, "SZB6120", "Multimedia Adapter" } ,
	{ 0x1112, 0X2340, "4 Port FEN Adapter", "4 10/100 UTP Fast Ethernet Adapter" } ,
	{ 0x1112, 0x2200, "", "FDDI adapter" } ,
	{ 0x1112, 0x2300, "", "fast ethernet adapter" } ,
	{ 0x1112, 0x2400, "", "ATM adapter" } ,
	{ 0x1117, 0x9500, "", "max-lc SVGA card" } ,
	{ 0x1117, 0x9501, "", "max-lc image processing" } ,
	{ 0x1119, 0x0000, "GDT6000/6020/6050", "SCSI RAID" } ,
	{ 0x1119, 0x0001, "GDT6000/6010", "SCSI RAID" } ,
	{ 0x1119, 0x0002, "GDT6110/6510", "SCSI RAID" } ,
	{ 0x1119, 0x0003, "GDT6120/6520", "2-chan SCSI RAID" } ,
	{ 0x1119, 0x0004, "GDT6530", "3-chan SCSI RAID" } ,
	{ 0x1119, 0x0005, "GDT6550", "5-chan SCSI RAID" } ,
	{ 0x111A, 0x0000, "155P-MF1", "" } ,
	{ 0x111C, 0x0001, "", "Powerbus Bridge" } ,
	{ 0x111F, 0x4A47, "", "Precision MX Video Engine Interface" } ,
	{ 0x111F, 0x5243, "", "Frame Capture Bus Interface" } ,
	{ 0x112E, 0x0000, "", "EIDE/hdd and IDE/cd-rom Ctrlr" } ,
	{ 0x112E, 0x000B, "", "EIDE/hdd and IDE/cd-rom Ctrlr" } ,
	{ 0x112F, 0x0000, "ICPCI", "" } ,
	{ 0x112F, 0x0001, "", "video frame grabber/processor" } ,
	{ 0x1134, 0x0001, "", "Raceway Bridge" } ,
	{ 0x1135, 0x0001, "", "Printer Cntrlr" } ,
	{ 0x1138, 0x8905, "8905", "STD 32 Bridge" } ,
	{ 0x1139, 0x0001, "", "VGA" } ,
	{ 0x1139, 0x0001, "", "VGA compatible 3D graphics" } ,
	{ 0x113C, 0x0001, "PCI-SDK", "PCI i960 Evaluation Platform" } ,
	{ 0x113C, 0x0911, "PCI 911", "PCI-based i960Jx Intelligent I/O Contro" } ,
	{ 0x113C, 0x0912, "PCI 912", "i960Cx-based Intelligent I/O Controller" } ,
	{ 0x113C, 0x0913, "PCI 913", "i960Hx-based Intelligent I/O Controller" } ,
	{ 0x1141, 0x0001, "", "EIDE/ATAPI super adapter" } ,
	{ 0x1142, 0x3210, "ProMotion 3210", "VGA/AVI Playback Accelerator" } ,
	{ 0x1142, 0x6410, "", "GUI Accelerator" } ,
	{ 0x1142, 0x6412, "", "GUI Accelerator" } ,
	{ 0x1142, 0x6420, "", "GUI Accelerator" } ,
	{ 0x1142, 0x6422, "Provideo", "" } ,
	{ 0x1142, 0x6424, "", "GUI Accelerator" } ,
	{ 0x1142, 0x6426, "", "GUI Accelerator" } ,
	{ 0x1144, 0x0001, "", "Noservo Cntrlr" } ,
	{ 0x1148, 0x4000, "", "FDDI adapter" } ,
	{ 0x1158, 0x3011, "", "Tokenet/vg 1001/10m anylan" } ,
	{ 0x1158, 0x9051, "", "Lanfleet/Truevalue" } ,
	{ 0x1159, 0x0001, "MV1000", "" } ,
	{ 0x1161, 0x0001, "", "Host Bridge" } ,
	{ 0x1165, 0x0001, "", "Motion JPEG rec/play w/audio" } ,
	{ 0x1178, 0xAFA1, "", "Fast Ethernet" } ,
	{ 0x1179, 0x0601, "", "Toshiba CPU to PCI bridge" } ,
	{ 0x1179, 0x060A, "", "Toshiba ToPIC95 CardBus Controller" } ,
	{ 0x1189, 0x1592, "", "?" } ,
	{ 0x118C, 0x0014, "PCIB", "C-bus II to PCI bus host bridge chip" } ,
	{ 0x118D, 0x0001, "n/a", "Raptor-PCI framegrabber" } ,
	{ 0x1191, 0x0001, "", "IDE Ctrlr" } ,
	{ 0x1191, 0x0002, "", "IDE Cntrlr" } ,
	{ 0x1191, 0x0003, "", "SCSI-2 cache Cntrlr" } ,
	{ 0x1191, 0x0004, "ATP8400", "ASIC cache accelerator " } ,
	{ 0x1191, 0x8001, "", "SCSI-2 cache Cntrlr" } ,
	{ 0x1191, 0x8002, "", "SCSI-2 Cntrlr" } ,
	{ 0x1193, 0x0001, "1221", "" } ,
	{ 0x11A9, 0x4240, "AMCC S5933Q", "Intelligent Serial Card" } ,
	{ 0x11AB, 0x0146, "GT-64010", "System ctrlr w/PCI for R46xx CPU" } ,
	{ 0x11AB, 0x4801, "GT-48001", "8 port switched ethernet ctrlr" } ,
	{ 0x11B0, 0x0292, "V292PBC", "Am29030/40 Bridge" } ,
	{ 0x11B0, 0x0960, "V96xPBC", "i960 Bridges for i960 Processors" } ,
	{ 0x11B0, 0xC960, "V96DPC", "i960 Dual PCI Bridge" } ,
	{ 0x11B9, 0xC0ED, "SSA Ctrlr", "" } ,
	{ 0x11C8, 0x0658, "PSB", "PCI-SCI Bridge" } ,
	{ 0x11CB, 0x2000, "PCI-9050", "Target Interface" } ,
	{ 0x11CB, 0x4000, "SUPI-1", "Target Interface" } ,
	{ 0x11CB, 0x8000, "T225", "Bridge" } ,
	{ 0x11D1, 0x01F7, "VxP524", "PCI Video Processor" } ,
	{ 0x11F8, 0x7375, "PM7375", "LASAR-155 ATM SAR" } ,
	{ 0x120E, 0x0100, "Cyclom-Y", "Multiport Serial Card" } ,
	{ 0x120E, 0x0200, "Cyclom-Z", "Intelligent Multiport Serial" } ,
	{ 0x1220, 0x1220, "AMCC 5933", "TMS320C80 DSP/Imaging Board" } ,
	{ 0x12C5, 0x0081, "pcivst", "PCI Thresholding Engine" } ,
	{ 0x1C1C, 0x0001, "82C101", "IDE Ctrlr" } ,
	{ 0x1C1C, 0x0001, "FR710", "EIDE Ctrlr" } ,
	{ 0x1DE1, 0xDC29, "DC290M", "Bus Master IDE PCI 2 controllers" } ,
	{ 0x3D3D, 0x0004, "3C0SX", "GUI Accelerator" } ,
	{ 0x4005, 0x2301, "AVL2301", "GUI Accelerator" } ,
	{ 0x4005, 0x2302, "AVG2302", "GUI Accelerator" } ,
	{ 0x4B10, 0x3080, "", "SCSI - ti" } ,
	{ 0x4B10, 0x4010, "", "Fast/wide SCSI-2" } ,
	{ 0x5333, 0x5631, "86C325", "Virge 3D GUI Accelerator" } ,
	{ 0x5333, 0x8800, "", "Vision 866 GUI Accelerator" } ,
	{ 0x5333, 0x8801, "", "Vision 964 GUI Accelerator" } ,
	{ 0x5333, 0x8810, "86C764", "Trio 32 GUI Accelerator v0" } ,
	{ 0x5333, 0x8811, "86C764", "Trio 32/64 GUI Accelerator v1" } ,
	{ 0x5333, 0x8813, "86C764", "Trio 32/64 GUI Accelerator v3" } ,
	{ 0x5333, 0x883D, "86C988", "ViRGE/VX 3D GUI Accelerator" } ,
	{ 0x5333, 0x8880, "86C868", "GUI Accelerator v0" } ,
	{ 0x5333, 0x8881, "86C868", "GUI Accelerator v1" } ,
	{ 0x5333, 0x8882, "86C868", "GUI Accelerator v2" } ,
	{ 0x5333, 0x8883, "86C868", "GUI Accelerator v3" } ,
	{ 0x5333, 0x88B0, "86C928", "GUI Accelerator v0" } ,
	{ 0x5333, 0x88B1, "86C928", "GUI Accelerator v1" } ,
	{ 0x5333, 0x88B2, "86C928", "GUI Accelerator v2" } ,
	{ 0x5333, 0x88B3, "86C928", "GUI Accelerator v3" } ,
	{ 0x5333, 0x88C0, "86C864", "GUI Accelerator v0" } ,
	{ 0x5333, 0x88C1, "86C864", "GUI Accelerator v1" } ,
	{ 0x5333, 0x88C2, "86C864", "GUI Accelerator v2" } ,
	{ 0x5333, 0x88C3, "86C864", "GUI Accelerator v3" } ,
	{ 0x5333, 0x88D0, "86C964", "GUI Accelerator v0" } ,
	{ 0x5333, 0x88D1, "86C964", "GUI Accelerator v1" } ,
	{ 0x5333, 0x88D2, "86C964", "GUI Accelerator v2" } ,
	{ 0x5333, 0x88D3, "86C964", "GUI Accelerator v3" } ,
	{ 0x5333, 0x88F0, "86C968", "GUI Accelerator v0" } ,
	{ 0x5333, 0x88F1, "86C968", "GUI Accelerator v1" } ,
	{ 0x5333, 0x88F2, "86C968", "GUI Accelerator v2" } ,
	{ 0x5333, 0x88F3, "86C968", "GUI Accelerator v3" } ,
	{ 0x6374, 0x6773, "GPPCI", "PCI Interface" } ,
	{ 0x8008, 0x0010, "PCI-WDOG1", "PCI-Watchdog 1" } ,
	{ 0x8008, 0x0011, "PWDOG2", "Watchdog2/PCI" } ,
	{ 0x8086, 0x0482, "82375EB", "EISA Bridge" } ,
	{ 0x8086, 0x0483, "82424", "CPU (i486) Bridge (Saturn)" } ,
	{ 0x8086, 0x0484, "82378", "SIO ISA Bridge" } ,
	{ 0x8086, 0x0486, "82430ZX", "Aries i486 Bridge" } ,
	{ 0x8086, 0x04A3, "82434LX", "CPU (Pentium) Bridge" } ,
	{ 0x8086, 0x0960, "80960RP", "i960 RP Microprocessor/Bridge" } ,
	{ 0x8086, 0x1221, "82092AA", "PCMCIA Bridge" } ,
	{ 0x8086, 0x1222, "82092AA", "IDE Ctrlr" } ,
	{ 0x8086, 0x1223, "SAA7116", "" } ,
	{ 0x8086, 0x1227, "EtherExpress PRO100", " 10/100 Fast Ethernet Adapter Card" } ,
	{ 0x8086, 0x1228, "EE PRO/100 Smart", "Intelligent 10/100 Fast Ethernet Adapte" } ,
	{ 0x8086, 0x1229, "82557", "Fast Ethernet LAN Controller" } ,
	{ 0x8086, 0x122D, "82437FX", "Host Bridge (Triton)" } ,
	{ 0x8086, 0x122E, "82371FB", "ISA Bridge (Triton)" } ,
	{ 0x8086, 0x1230, "82371FB", "IDE Interface (Triton)" } ,
	{ 0x8086, 0x1237, "82440FX", "PCI and Memory Controller (Mars)" } ,
	{ 0x8086, 0x1239, "82371FB", "IDE Interface (Triton)" } ,
	{ 0x8086, 0x1250, "82430HX", "TXC Host Bridge (Triton II)" } ,
	{ 0x8086, 0x1960, "80960RP", "i960RP Microprocessor" } ,
	{ 0x8086, 0x7000, "82371SB", "PIIX3 ISA Bridge (Triton II)" } ,
	{ 0x8086, 0x7010, "82371SB", "PIIX3 IDE Interface (Triton II)" } ,
	{ 0x8086, 0x7020, "82371SB", "PIIX3 USB Interface (Triton II)" } ,
	{ 0x8086, 0x7030, "82430VX", "Host Bridge (Triton VX)" } ,
	{ 0x8086, 0x7110, "82371AB", "PIIX4 ISA Bridge" } ,
	{ 0x8086, 0x84C4, "82450KX/GX", "450KX/GX PCI Bridge (Orion)" } ,
	{ 0x8086, 0x84C5, "82453KX/GX ", "450KX/GX Memory Controller (Orion)" } ,
	{ 0x8800, 0x2008, "", "video assistant component" } ,
	{ 0x9004, 0x1078, "AIC-7810C", "RAID Coprocessor" } ,
	{ 0x9004, 0x5078, "x940", "Fast-wide SCSI-II Ctrlr" } ,
	{ 0x9004, 0x5575, "AHA-2930P", "SCSI Ctrlr" } ,
	{ 0x9004, 0x7078, "AIC-7870P", "Fast-wide SCSI-II Ctrlr" } ,
	{ 0x9004, 0x7178, "AHA-2940", "Fast-wide SCSI Ctrlr" } ,
	{ 0x9004, 0x7278, "x940", "2-chan Fast-wide SCSI Ctrlr" } ,
	{ 0x9004, 0x7378, "AHA-3985", "4-chan RAID SCSI Ctrlr" } ,
	{ 0x9004, 0x7478, "AHA-2944", "SCSI Ctrlr" } ,
	{ 0x9004, 0x7810, "aic 7810", "Memory control IC" } ,
	{ 0x9004, 0x7850, "aic-7850", "SCSI IC" } ,
	{ 0x9004, 0x7855, "aha 2930", "Single SCSI channel" } ,
	{ 0x9004, 0x7870, "aic-7870", "SCSI IC" } ,
	{ 0x9004, 0x7871, "aha 2940", "SCSI " } ,
	{ 0x9004, 0x7872, "aha 3940", "Multiple SCSI channels" } ,
	{ 0x9004, 0x7873, "aha 3980", "Multiple SCSI channels" } ,
	{ 0x9004, 0x7874, "aha 2944", "Differential SCSI" } ,
	{ 0x9004, 0x7880, "aic7880", "Fast 20 SCSI" } ,
	{ 0x9004, 0x8078, "7880 (?)", "SCSI Ctrlr" } ,
	{ 0x9004, 0x8178, "7881 (?)", "Ultra/Ultra-wide SCSI Ctrlr" } ,
	{ 0x9004, 0x8278, "AHA-3940U/UW", "Multiple SCSI channels" } ,
	{ 0x907F, 0x2015, "IDE-2015PL", "EIDE Ctrlr" } ,
	{ 0xEDD8, 0xA091, "Stingray", "GUI Accelerator" } ,
	{ 0xEDD8, 0xA099, "Stingray", "2000PV GUI Accelerator" } ,
	{ 0xEDD8, 0xA0A1, "ark2000mt", "64-bit GUI accelerator w/DCI playback" } ,
	{ 0xFFFF, 0x0140, "BAD Buslogic BT-946", "" } ,
} ;

