#include	"ctype.h"

#pragma export on
void process_refs(record_ref aReference, BMessage* msg, void*);
#pragma export reset

void main()
{
}

void makeStoreLowercase(BStore *aStore)
{
	char			aName[B_FILE_NAME_LENGTH];
	char			*aNamePtr = aName;
	
	aStore->GetName(aName);
	if (aStore->Error() != B_NO_ERROR) return;
	for (;*aNamePtr;aNamePtr++) {
		*aNamePtr = tolower(*aNamePtr);
	}
	aStore->SetName(aName);
}

void makeDirectoryLowercase(BDirectory *aDirectory)
{
	makeStoreLowercase(aDirectory);
	
	long		i,count;
	BFile		eachFile;
	BDirectory	eachDirectory;
	
	count = aDirectory->CountFiles();
	for (i = 0; i < count; i++) {
		aDirectory->GetFile(i, &eachFile);
		if (eachFile.Error() == B_NO_ERROR)
			makeStoreLowercase(&eachFile);
	}

	count = aDirectory->CountDirectories();
	for (i = 0; i < count; i++) {
		aDirectory->GetDirectory(i, &eachDirectory);
		if (eachDirectory.Error() == B_NO_ERROR)
			makeDirectoryLowercase(&eachDirectory);
	}
}

void process_refs(record_ref aReference, BMessage* msg, void*)
{
	ulong			type;
	long			numOfRefs;
	BFile			eachFile;
	BDirectory		eachDirectory;
	record_ref		eachReference;
		
	
	msg->GetInfo("refs", &type, &numOfRefs);
	if (numOfRefs == 0) {
	
		eachDirectory.SetRef(aReference);
		if (eachDirectory.Error() == B_NO_ERROR)
			makeDirectoryLowercase(&eachDirectory);
		else {
			BAlert	*anAlert = new BAlert("", "No valid selection found.", "Cancel");
			anAlert->Go();
		};
		return;
	}
	
	for (long i = 0; i < numOfRefs; i++) {
		eachReference = msg->FindRef("refs", i);
		if (does_ref_conform(eachReference, "File")) {
			eachFile.SetRef(eachReference);
			if (eachFile.Error() == B_NO_ERROR)
				makeStoreLowercase(&eachFile);
		} else {
			eachDirectory.SetRef(eachReference);
			if (eachDirectory.Error() == B_NO_ERROR)
				makeDirectoryLowercase(&eachDirectory);
		}
	}
}