#ifndef StatusWindow_h
#define StatusWindow_h

#include <InterfaceKit.h>

#define STATXGUTTER 2
#define SW_StopButton 'SSTP'

class WinStatusBar : public BStatusBar
{
	public:
	
	WinStatusBar(	BRect frame,
				const char *name,
				const char *static_label = NULL,
				const char *trailing_static_label = NULL);
	virtual	~WinStatusBar();
	virtual	bool StopRequested();
	virtual void Stop();
	virtual void MouseDown( BPoint point );
	virtual void Draw( BRect rect );

	private:
		bool selected;
};

#define STATUSWINDOWVIEWS 2

class StatusWindow : public BWindow
{
	public:
		StatusWindow( BRect frame, char *name );
	virtual void Quit();
		AddStatusBar( WinStatusBar *sbar );
		RemStatusBar( WinStatusBar *sbar );
	virtual void MessageReceived( BMessage *msg );
	
	private:
		BView *background;
		BButton *stop;
		BRect stopfr;
		float height;
};

#endif
