#include "HTTPGet.h"

HTTPGetWindow::HTTPGetWindow( BRect frame, char *name ) : BWindow( frame, name, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE )
{
	BRect rect;
	float strwidth;

	Lock();
	
	frame.Set( 0, 0, frame.Width(), frame.Height() );
	background = new BView( frame, "Background", B_FOLLOW_ALL_SIDES, B_FRAME_EVENTS|B_WILL_DRAW );
	AddChild( background );
	background->SetViewColor( 200, 200, 200 );
	background->SetLowColor( 200, 200, 200 );

	rect.Set( XGUTTER, YGUTTER, WINWIDTH - XGUTTER, YGUTTER + FONTSIZE + 4 );
	url = new BTextControl( rect, "URL", "URL:", 0, 0 );
	background->AddChild( url );
	strwidth = url->StringWidth( "URL:" );
	url->SetDivider( strwidth + 5.0 );
	rect = url->Frame();
	
	rect.OffsetBy( 0, INNERGUTTER + rect.Height() );
	get = new BButton( rect, "Get", "Get", new BMessage( HTGT_GetButton ) );
	background->AddChild( get );
	rect = get->Frame();
	
	ResizeTo( WINWIDTH, rect.bottom + YGUTTER );
	Unlock();
}

void HTTPGetWindow::MessageReceived( BMessage *msg )
{
	NetSocket *sock;
	
	switch( msg->what )
	{
		case HTGT_GetButton:
			strcpy( urlcp, url->Text() );
			RunSavePanel( getfilename( urlcp ) );
			break;
		default:
			BWindow::MessageReceived( msg );
			break;
	}
}

bool HTTPGetWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

void HTTPGetWindow::SaveRequested( record_ref dir, const char *filename )
{
	((HTTPGetApplication *)be_app)->GetURL( urlcp, dir, filename );
}

