/*
	Hello
*/

#include "HTTPGet.h"

main()
{
	HTTPGetApplication *myapp;
	
	myapp = new HTTPGetApplication();
	myapp->Run();
	delete myapp;
	return( 0 );
}

HTTPGetApplication::HTTPGetApplication() : BApplication( 'HTGT' )
{
	BRect rect;
	BMenuItem *item;
	BPopUpMenu *menu = new BPopUpMenu( "", FALSE, FALSE );
	
	item = new BMenuItem( "About HTTPGet...",
new BMessage( B_ABOUT_REQUESTED ) );
 
	item->SetTarget( be_app );
	menu->AddItem( item );
	
	item = new BMenuItem( "Quit", new BMessage( B_QUIT_REQUESTED ), 'Q' );
	item->SetTarget( be_app );
	menu->AddItem( item );
	
	be_app->SetMainMenu( menu );
	
	rect.Set( 100, 100, 100 + WINWIDTH, 100 + 10 );
	win = new HTTPGetWindow( rect, "HTTPGet" );
	status = new StatusWindow( rect, "HTTPGet Status" );

	win->Show();
}

void HTTPGetApplication::MessageReceived( BMessage *msg )
{
	NetSocket *sock;
	
	switch( msg->what )
	{
		case 'htgt':
			{
				const char *file;
				
				strcpy( urlcp, msg->FindString( "url" ) );
				if( !(file = msg->FindString( "filename" )) )
					file = getfilename( urlcp );
				strcpy( filename, file );
				GetURL( urlcp, msg->FindRef( "dir" ), filename );
			}
			break;
		default:
			BApplication::MessageReceived( msg );
			break;
	}
}

void HTTPGetApplication::AboutRequested()
{
	BAlert *alert;
	
	alert = new BAlert( "HTTPGet", "HTTPGet\nby Tim Stack", "OK" );
	alert->Go();
}

void HTTPGetApplication::GetURL( char *url, record_ref dir, const char *filename )
{
	BDirectory bdir( dir );
	BFile bfile;
	BRect rect;
	
	if( bdir.Create( filename, &bfile ) == B_NO_ERROR )
	{
		rect.Set( 0, 0, 200, 10 );
		status->AddStatusBar( new URLStatus( url, rect, bfile.Record()->Ref() ) );
	}
	else
	{
		BAlert *alert;
		char errorstr[256];
		
		sprintf( errorstr, "Cannot create file:\n%s", filename );
		alert = new BAlert( "HTTPGet", errorstr, "OK" );
		alert->Go();
	}
}

char *getfilename( char *url )
{
	char *slash = 0;
	int index;
	
	for( index = 0; url[index]; index++ )
	{
		if( url[index] == '/' )
			slash = &url[index];
	}
	slash++;
	return( slash );
}
