//*******************************************************************************
// Project	: debugWindow_test (BApp): a debugWindow library demo.
// BeOS		: DR9 - AA - Update 5-28-97 
// File 	: debugWindow_test.cpp
// Author	: Nicolas Leclercq
// email	: leclercq@lure.u-psud.fr
//*******************************************************************************


#pragma mark * Headers
//------------------------------------------------------------------------------
// HEADERS
//------------------------------------------------------------------------------

#ifndef DW_TEST
#include "debugWindow_test.h"
#endif

//*** dW ****
#ifndef DEBUG_WINDOW_H
	#include "debugWindow.h"
#endif
//*** dW ****

#pragma mark * Classes
//------------------------------------------------------------------------------
// CLASSes
//------------------------------------------------------------------------------
class threadObj {
	public	:
				long 		Go(void);			
	private	:
		static 	long 		entry_func(void *arg);
				long		entryFunc(void);
				thread_id 	mThisThread;
		static 	long 		mThreadObjCount;
};
long threadObj::mThreadObjCount = 0L;
//------------------------------------------------------------------------------

#pragma mark ---------------------------------------------------
//------------------------------------------------------------------------------
// 	routine :	main			
//------------------------------------------------------------------------------
main()
{
	dW_Test *thisApp = new dW_Test();
	if ( thisApp != NULL ) {
		 thisApp->Run();
		 delete (thisApp);
	}
	return (B_NO_ERROR);
}

#pragma mark ---------------------------------------------------

//------------------------------------------------------------------------------
// 	routine :	dW_Test::dW_Test (CONSTUCTOR)					
//------------------------------------------------------------------------------

dW_Test::dW_Test():BApplication('NICO')
{

}

//------------------------------------------------------------------------------
// 	routine :	dW_Test::ReadyToRun 					
//------------------------------------------------------------------------------
void
dW_Test::ReadyToRun()
{
	//Initialize random generator...
	srand(system_time());
	
    //*** dW ****
	dW_Init();  //call dW_Init to create and open debugWindow
	//*** dW ****
	
	//In this example we create two objects (threads) that send message to 
	//debugWindow at random interval (see threadObj::entryFunc() ).
	threadObj* threadObj_1 = new threadObj;
	threadObj* threadObj_2 = new threadObj;
	//Spawn then resume threads... 
	threadObj_1->Go();
	threadObj_2->Go();
	
	
	// just for fun... we send messages to debugWindow 
	char  name[B_OS_NAME_LENGTH];
	short myObjCount = 2;
	strcpy(name,"threadObj");
	
	//*** dW ****
	dW_PostMsg("Hello... welcome to debugWindow"); 
    dW_PostMsg("Time since booting is %.5Lf s",system_time()*1E-6); 
	dW_PostMsg("We created %d objects of type %.32s.",myObjCount,name); 
	//*** dW ****

}


//------------------------------------------------------------------------------
// 	routine :	dW_Test::MessageReceived			
//------------------------------------------------------------------------------
void
dW_Test::MessageReceived (BMessage *message )
{
	switch (message->what) {
		default:
			BApplication::MessageReceived(message);
			break;
	}
}

//------------------------------------------------------------------------------
// 	routine :	dW_Test::ArgvReceived		
//------------------------------------------------------------------------------
void
dW_Test::ArgvReceived ( int32	 argc, char	*argv[] )
{
#pragma unused(argc,argv)
}

#pragma mark ---------------------------------------------------
//------------------------------------------------------------------------------
// 	routine :	threadObj::threadObj		
//------------------------------------------------------------------------------
//threadObj::threadObj()
//{
//
//}

//------------------------------------------------------------------------------
// 	routine :	threadObj::Go		
//------------------------------------------------------------------------------
long threadObj::Go(void)
{
	char tName[B_OS_NAME_LENGTH];
	
	sprintf(tName,"threadObj_%ld",mThreadObjCount+1);
	mThisThread = spawn_thread(entry_func,tName,B_NORMAL_PRIORITY,this);
	if ( B_NO_ERROR > mThisThread ) return B_ERROR;
	mThreadObjCount++;
	return( resume_thread(mThisThread) );
}

//------------------------------------------------------------------------------
// 	routine :	threadObj::entry_func
//	note	: 	What a trick ! 
//				Everything is explains in The Kernel Kit:Threads and Teams doc.		
//------------------------------------------------------------------------------
long threadObj::entry_func(void *arg)
{
	threadObj* thisObj = (threadObj*)arg;
	return(thisObj->entryFunc());
}

//------------------------------------------------------------------------------
// 	routine :	threadObj::entryFunc
//	note	: 	threadObj "main" routine.		
//------------------------------------------------------------------------------
long threadObj::entryFunc(void)
{
	static msgCount=0L;

	while ( true ) // forever or till thread exits...
	{
		// sleep during random time...
		snooze((500000*rand()) % 2000000); 	
		// then send msg to debugWindow...		
		dW_PostMsg("Here is message n°%ld",++msgCount);
	}
	return(B_NO_ERROR);
}

