///////////////////////////////////////////////////////////////
//
// Some built in bitmaps... don't ask me where I got them from
// and I won't tell!
//
///////////////////////////////////////////////////////////////

#include "TreeList.h"

/*This Image is 8 pixels wide, 4 pixels high, and 8 bits deep*/
static unsigned char idata_downarrow[] = 
{
8,4, 
0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26,
0xFF, 0x26, 0x6C, 0x6C, 0x6C, 0x6C, 0x26, 0xFF,
0xFF, 0xFF, 0x26, 0x6C, 0x6C, 0x26, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0x26, 0x26, 0xFF, 0xFF, 0xFF,
};

/*This Image is 4 pixels wide, 8 pixels high, and 8 bits deep*/
static unsigned char idata_rightarrow[] = 
{
4,8,
0x26, 0xFF, 0xFF, 0xFF,
0x26, 0x26, 0xFF, 0xFF, 
0x26, 0x6C, 0x26, 0xFF,
0x26, 0x6C, 0x6C, 0x26,
0x26, 0x6C, 0x6C, 0x26,
0x26, 0x6C, 0x26, 0xFF,
0x26, 0x26, 0xFF, 0xFF,
0x26, 0xFF, 0xFF, 0xFF
};

/*This Image is 7 pixels wide, 7 pixels high, and 8 bits deep*/
static unsigned char idata_minus[] = 
{
7,7,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x3F,
0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x3F,
0x00, 0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x3F,
0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x3F,
0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x3F,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F
};

/*This Image is 7 pixels wide, 7 pixels high, and 8 bits deep*/
static unsigned char idata_plus[] = 
{
7,7,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x3F,
0x00, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x00, 0x3F,
0x00, 0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x3F,
0x00, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x00, 0x3F,
0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x3F,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F
};

static unsigned char* image_data[ TreeList::TL_IMAGECOUNT] = {
	idata_downarrow,
	idata_rightarrow,
	idata_minus,
	idata_plus
};

static BBitmap* images[ TreeList::TL_IMAGECOUNT];

BBitmap* TreeList::GetStandardImage( ImageIndex image)
{
	if ( !images[image])
	{
		BBitmap* bitmap;
		unsigned char* idata = image_data[image];
		BRect imagerect( 0, 0, (idata[0] - 1) , (idata[1] - 1));
			
		bitmap = new BBitmap( imagerect, B_COLOR_8_BIT);
		::memcpy( bitmap->Bits(), &(idata[2]), bitmap->BitsLength());
		
		images[image] = bitmap;
	}
	
	return images[image];	
}

void TreeList::DrawCenteredImage( BView* view, BPoint where, const BBitmap* image)
{
	BRect br = image->Bounds();
		
	// Adjust to center bitmap
	where.x -= br.Width() / 2.0;
	where.y -= br.Height() / 2.0;

	// Adjust mode to ensure transparency		
	view->SetDrawingMode(B_OP_OVER);
	view->DrawBitmap( image, where);
	view->SetDrawingMode(B_OP_COPY);
}
