/*

	TBMSearch.h
	Copyright 1997 Infant Software
	All Rights Reserved.
	
	Algorithm for a Tuned Boyer-Moore ascii text search. Faster than standard Boyer-Moore
	by 10% in the average case, unlike some Boyer-Moore derivatives that don't compute delta2
	at all, thereby increasing both speed and the length of execution in a worst case scenario,
	we use Sundays mini-delta2 skip. Worse case scenarios are as such:
	
	Standard BMSearch- 0(lenSearchFor + lenSearchIn)
	
	No delta2 searches- 0(lenSearchFor * lenSearchIn)
	
	This TBM falls somewhere in between the two. Note that the worst case for this algorithm
	brougth about by highly repetitive text, which is were the Standard Boyer-Moore search 
	excels.
	
	This software is in the public domain.
	Improvements welcomed at runt@inch.com.
		
*/

#ifndef _TBM_SEARCH_H
#define _TBM_SEARCH_H

/*
	*- NOTE: searchIn must have room for lenSearchIn + lenSearchFor bytes. -*
	lenSearchIn is the length of the searchIn sting minus the added buffer. Example
	usage:
		char text [ 160 ];
		char pattern [ 80 ];
	
		gets(text);
		gets(pat);
		int lenSearchIn = strlen(text);
		int lenSearchFor = strlen(pattern);
	
	
		int result = TBMSearch(text, lenSearchIn, pattern, lenSearchFor);
*/

int TBMSearch(char * searchIn, int lenSearchIn, char * searchFor, int lenSearchFor);

/* Maximum Length of searchFor string .*/

const int MAX_PATTERN_SIZE = 80;

#endif