/*
	
	TBMSearch.cpp
	Copyright 1997 Infant Software
	All Rights Reserved.
	
	See TBMSearch.h for interface and implementation notes.
	
*/

#ifndef _TBM_SEARCH_H
	#include "TBMSearch.h"
#endif

#ifndef __string__
	#include <string.h>
#endif

const int ALPHABET = 256;
static void PreProcess(char *, int, int *, int *);

void PreProcess(char * searchFor, int lenSearchFor, int * delta1, int * miniDelta2)
{
	/* 
		Compute delta1, which determines how much to skip
	 	based on what text character caused the mismatch
	 	we mismatched on.
	 */

	memset(delta1, lenSearchFor, ALPHABET);

	for (int i = 0; i < lenSearchFor; i++) 
		delta1 [ searchFor [ i ] ] = lenSearchFor - i - 1;

	/*
		Compute miniDelta2.
	*/

	int index = lenSearchFor - 1;
	char skipc = searchFor [ index ];
	while (index > 0) {
		if (searchFor [ --index ] == skipc) 
			break;
	}
	
	*miniDelta2 = lenSearchFor - index - 1;
	
	/*
		If there is no recurrence, shift by 1.
	*/
	
	if (miniDelta2 == 0)
		*miniDelta2 = 1;
}

/*
	*- NOTE: searchIn must have room for lenSearchIn + lenSearchFor bytes. -*
*/

int TBMSearch(char * searchIn, int lenSearchIn, char * searchFor, int lenSearchFor)
{
	int delta1 [ ALPHABET ];
	int miniDelta2 [ MAX_PATTERN_SIZE ];
	int matchPoint = -1;
	PreProcess(searchFor, lenSearchFor, delta1, miniDelta2);

	char * searchBuffer = searchIn + lenSearchFor - 1;
	char * ptrEndSI = searchIn + lenSearchIn;
	char * ptrEndSF = searchFor + lenSearchFor - 1;

	/*
		Add in lenSearchIn sentinels. Save whats there in case we need to restore.
	*/

	char savedChars [ MAX_PATTERN_SIZE ];
	
	memcpy(savedChars, ptrEndSI, lenSearchFor);
	memset(ptrEndSI, searchFor [ lenSearchFor - 1 ], lenSearchFor);
	
	while (searchBuffer < ptrEndSI) {
		int i = delta1 [ *searchBuffer ];
		while ( i ) {
			i = delta1 [ *(searchBuffer += i) ];
			i = delta1 [ *(searchBuffer += i) ];
			i = delta1 [ *(searchBuffer += i) ];
		}
		if ( searchBuffer >= ptrEndSI )
			break;

		/*
			Reverse order match loop.
		*/
		
		char * searchPointSF = ptrEndSF;
		char * searchPointSB = searchBuffer;
		
		while ( 
			--searchPointSF >= searchFor && 
			*searchPointSF == *--searchPointSB 
			) {};
			
		if ( searchPointSF < searchFor ) {
			/*
				Set Position of Match
			*/
			matchPoint = searchPointSB - searchIn;
			break;
		}

		/*
			Compute amount to skip.
		*/
		
		searchBuffer += *miniDelta2;
	}
	
	/* 
		Restore text to where sentinel resided.
	*/
	
	memcpy(ptrEndSI, savedChars, lenSearchFor);
	
	return matchPoint;
}
	

               
