/*

	PrefServer-client demo 
	
*/

#include "prefclient.h"

BRect winframe;

class mywin : public BWindow
{
	public:
		mywin(BRect rect, char *name, window_type type, uint32 flags)
			: BWindow(rect,name,type,flags)
		{};
		bool QuitRequested()
		{
			winframe=Frame();
			be_app->PostMessage(B_QUIT_REQUESTED);
			return true;
		};
};



main()
{	
	BApplication app("application/x-marcone-prefclient");
	mywin *win;
	Preference *mypref;


	// create a Preference object and add some default values
	mypref=new Preference();
	mypref->AddRect("winframe",BRect(100,100,300,200));
	// load latest settings from disk (or whereever the PrefServer is storing them)
	mypref->Load();
	// extract member, note that this will not fail, since we put a default value in there
	mypref->FindRect("winframe",&winframe);
	
	// this function is included in libprefclient for your convenience
	// it will adjust the BRect so that it fits on the current workspace
	FitRectOnScreen(&winframe);	

	win=new mywin(winframe,"PrefClientDemo",B_TITLED_WINDOW,0L);
	win->Show();
	app.Run();

	mypref->ReplaceRect("winframe",winframe);
	mypref->Save();

	return(0);
}
