#include "Logger.h"
#include <stdarg.h>

const int  LOGGER_MESSAGE = 256;
const char LOGGER_TEXTKEY[] = "text";
const char LOGGER_SOURCEKEY[] = "source";
const char LOGGER_SEVERITYKEY[] = "severity";

static BMessenger* logger = 0;
static bool retrying = FALSE;
static BMessenger* GetLogger();

void StartLogging( bool retry)
{
	if ( !logger)
	{
		retrying = retry;
		GetLogger();
	}
}

void StopLogging()
{
	if ( logger)
	{
		LogPuts( "Logger client", LOGGER_INFORMATIONAL, "Disconnected");
		delete logger;
		logger = 0;
	}
	retrying = FALSE;
}

void LogPuts( const char* src, LoggerSeverity sev, const char* text)
{
	if ( !logger && retrying)
		GetLogger();
	
	if ( logger)
	{
		BMessage* msg = new BMessage( LOGGER_MESSAGE);
		
		if (src)
			msg->AddString( LOGGER_SOURCEKEY, src);
		else
			msg->AddString( LOGGER_SOURCEKEY, "Uranus");
		
		msg->AddLong( LOGGER_SEVERITYKEY, long(sev));
		
		if (text)
			msg->AddString( LOGGER_TEXTKEY, text);
		else
			msg->AddString( LOGGER_TEXTKEY, "One hand clapping");
		
		
		if( logger->SendMessage( msg) != B_NO_ERROR)
		{
			BMessenger* temp = logger;
			logger = 0;
			
			// Send failed, delete failing messenger
			delete temp;
			
			// It is not clear whether I should delete the
			// message I created here... I assume not.
		}
	}
}

void LogPrintf( const char* src, 
                LoggerSeverity sev, 
                const char* format,
                ...
)
{
	char buffer[1024]; // look out for overflow!
	
	va_list ap;
	va_start(ap, format);
	vsprintf( buffer, format, ap);
	
	LogPuts( src, sev, buffer); 	
}

// Precondition... logger == 0
static BMessenger* GetLogger()
{
	BMessenger* newlogger;
	
	newlogger = new BMessenger( 'Logg');
	
	if (newlogger->Error() == B_NO_ERROR)
	{
		// Success...
		logger = newlogger;
		LogPuts( "Logger client", LOGGER_INFORMATIONAL, "Connected");
	}
	else
	{
		delete newlogger;
	}
	
	return logger;
}