#include <AppDefs.h>
#include <Application.h>
#include <Roster.h>
#include <Message.h>
#include <Messenger.h>
#include <SupportDefs.h>
#include <Errors.h>
#include <OS.h>
#include <stdio.h>

class CMDApplication : public BApplication {
public:
	CMDApplication( );
	void ReadyToRun( );
};

CMDApplication *app;

main()
{
	app = new CMDApplication( );
	app->Run( );
	delete app;
	return NULL;
}

/* CMDApplication constructor :

*/
CMDApplication::CMDApplication( )
	: BApplication( 'MYap' )
{
}

/* ReadyToRun :

*/
void CMDApplication::ReadyToRun( )
{
	printf( "trying to launch a script\n" );
	BMessenger *sender = new BMessenger( 'SCse' );
	if( sender->Error( )!=B_NO_ERROR ) {
		printf( "no SCserver\n" );
		delete sender;
		PostMessage( B_QUIT_REQUESTED );
		return ;
	}			
	BMessage *msg = new BMessage( 'SCdo' );
	msg->AddString( "SClanguage", "python" );
	msg->AddString( "SCfile", "tst.py" );
	msg->AddLong( "SCwhat", 'HiYa' );
	BMessage *reply;
	sender->SendMessage( msg, &reply );
	if( reply ) {
		if( reply->what==B_NO_REPLY )
			printf( "no reply from the script\n" );
		else {
			char what[ 5 ] = { 0, 0, 0, 0, 0 };
			*( long * )what = reply->what;
			printf( "what='%s'\n", what);
		}
		delete reply;
	}
	PostMessage( B_QUIT_REQUESTED );
}

//  1996 Benot Triquet
