/*
	SCserver
	The dispatcher for script execution requests
	(ScriptControl 0.1)
*/

#include <AppKit.h>
#include <StorageKit.h>
#include <Alert.h>
#include <SupportKit.h>
#include <OS.h>
#include <stdio.h>
#include <string.h>

struct Reply {
	thread_id thr;
	BMessage *msg;
};

class SCApplication : public BApplication {
public:
	SCApplication( );
	~SCApplication( );
	void AboutRequested( );
	void MessageReceived( BMessage * );
	void ReplyReceived( BMessage *, BMessage *, ulong, thread_id );
private:
	BList *pending;
};

SCApplication *app;

int main()
{
	app = new SCApplication( );
	app->Run( );
	delete app;
	return NULL;
}

void error_alert( char *text )
{
	BAlert *alert = new BAlert( "about", text, "OK", NULL, NULL, B_WIDTH_AS_USUAL,
	 B_STOP_ALERT );
	alert->Go( );
}

/* SCApplication constructor :

*/
SCApplication::SCApplication( )
	: BApplication( 'SCse' )
{
	pending = new BList( );
}

/* SCApplication destructor :

*/
SCApplication::~SCApplication( )
{
	for( ulong i = 0; i<pending->CountItems( ); i++ )
		delete ( ( Reply * )pending->ItemAt( i ) )->msg;
	delete pending;
}

void SCApplication::AboutRequested( )
{
	BAlert *alert = new BAlert( "about", "SCserver -- ScriptControl 1.0 \
1996 Benot Triquet", "OK" );
	alert->Go( );
}

/* MessageReceived :
Calls the SCxxxx for the language xxxx
*/
void SCApplication::MessageReceived( BMessage *msg )
{
	BMessage *reply, *forward;
	thread_id sender;
	app_info app;
	char text[ 64 ], sig[ 5 ] = { 0, 0, 0, 0, 0 };
	char launch[ B_FILE_NAME_LENGTH+2 ];
	record_ref ref;
	Reply *rep = new Reply;

	switch( msg->what ) {
		case 'SCdo': // do script or statement
			forward = new BMessage( msg );
			forward->what = msg->FindLong( "SCwhat" );
			if( msg->Error( )!=B_NO_ERROR ) {
				error_alert( "SCserver : no \"what\" field in 'SCdo' msg" );
				delete forward;
				return;
			}
			sender = msg->Sender( );
			be_roster->GetRunningAppInfo( sender, &app );
			*( ulong * )sig = app.signature;
printf("request from %s\n",sig);
			if( forward->IsSystem( ) ) {
				sprintf( text, "SCserver : illegal \"what\" in 'SCdo' msg from '%s'",
				 sig );
				error_alert( text );
				delete forward;
				return;
			}
			strcpy( launch, "SC" );
			strcat( launch, msg->FindString( "SClanguage" ) );
			if( msg->Error( )!=B_NO_ERROR ) {
				sprintf( text, "SCserver : no \"language\" field in 'SCdo' msg from\
'%s'", sig );
				error_alert( text );
				delete forward;
				return;
			}
			forward->RemoveName( "SCwhat" );
			forward->RemoveName( "SClanguage" );
			forward->AddLong( "SCsender", msg->Sender( ) );
			if( get_ref_for_path( launch, &ref )!=B_NO_ERROR ) {
				sprintf( text, "SCserver : %s is not installed (from '%s')",
				 msg->FindString( "language" ), sig );
				error_alert( text );
				delete forward;
				return;
			}
printf("trying to launch '%s', rec %d id %d\n",launch,ref.record,ref.database);
			if( be_roster->Launch( ref, forward, &rep->thr )!=B_NO_ERROR ) {
				sprintf( text, "SCserver : couldn't launch %s (from '%s')", launch, sig );
				error_alert( text );
				delete forward;
				return;
			}
printf("launched\n");
			rep->msg = msg;
			pending->AddItem( rep );
			DetachCurrentMessage( );
			break;
		default:
			BApplication::MessageReceived( msg );
	}
}

/* ReplyReceived :
Relays the replies.
*/
void SCApplication::ReplyReceived( BMessage *msg, BMessage *orig, ulong sig, thread_id main )
{
char what[ 5 ] = { 0, 0, 0, 0, 0 };
*( long * )what = msg->what;
printf( "reply received what='%s'\n", what);
*( long * )what = orig->what;
printf( "original had what='%s'\n", what);

	long i = 0;
	while( i<pending->CountItems( ) &&
	 main!=( ( Reply * )( pending->ItemAt( i ) ) )->thr )
		i++;
	if( i==pending->CountItems( ) ) {
		error_alert( "SCserver : unexpected reply !" );
		return ;
	}
	DetachCurrentMessage( );
	( ( Reply * )( pending->ItemAt( i ) ) )->msg->SendReply( msg );
	delete ( ( Reply * )( pending->ItemAt( i ) ) )->msg;
	pending->RemoveItem( i );
}

//  1996 Benot Triquet
