/* Copyright (C) 1996, Jake Hamby.  All rights reserved.

  This file is part of Aladdin Ghostscript.

  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.

  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* gsfront.cpp */
/* Shared library front-end to Ghostscript.  Simulates traditional "gs" */
/* executable, but opens a window for the native BeBox GUI driver */

#include <stdio.h>
#include <string.h>
#include <Application.h>
#include <ScrollView.h>
#include "PSView.h"
typedef PSView * HWND;		// Windows throwback
extern "C" {
#include "gsdll.h"
}

class PSWindow : public BWindow {
public:
	PSWindow(BRect frame, const char *title, window_type type, ulong flags);
	bool QuitRequested();
};

PSWindow::PSWindow(BRect frame, const char *title, window_type type,
			ulong flags) : BWindow(frame, title, type, flags)
{
}

bool PSWindow::QuitRequested() {
	be_app->PostMessage(B_QUIT_REQUESTED);
	return TRUE;
}

int
gsdll_callback(int message, char *str, unsigned long count)
{
    char *p;
    switch (message) {
    case GSDLL_STDIN:
        p = fgets(str, count, stdin);
        if (p)
             return strlen(str);
        else
             return 0; 
    case GSDLL_STDOUT:
        if (str != (char *)NULL)
            fwrite(str, 1, count, stderr);
        return count;
    case GSDLL_DEVICE:
        fprintf(stderr,"Callback: DEVICE %p %s\n", str,
        count ? "open" : "close");
        break;
    case GSDLL_SYNC:
        fprintf(stderr,"Callback: SYNC %p\n", str);
        break;
    case GSDLL_PAGE:
        fprintf(stderr,"Callback: PAGE %p\n", str);
        break;
    case GSDLL_SIZE:
        fprintf(stderr,"Callback: SIZE %p width=%d height=%d\n", str,
            (int)(count & 0xffff), (int)((count>>16) & 0xffff) );
        break;
    case GSDLL_POLL:
        return 0; /* no error */
    default:
        fprintf(stderr,"Callback: Unknown message=%d\n",message);
        break;
    }
            return 0;
}

char buf[256];

class PSApplication : public BApplication {
public:
    PSApplication(ulong sig);
private:
    PSWindow *mywind;
	PSView *psview;
	BScrollView *myscrollview;
};

int myargc;
char **myargv;

int main(int argc, char *argv[]) {
	myargc = argc;
	myargv = argv;
    PSApplication myapp('GHST');
    myapp.Run();
    return 0;
}

long gsloop(void *foo);

PSApplication::PSApplication(ulong sig) : BApplication(sig) {
	screen_info myscreen;
    get_screen_info(&myscreen);
	BRect frame(5, 10, myscreen.frame.right, myscreen.frame.bottom);
    mywind = new PSWindow(frame, "Main Ghostscript Window", B_DOCUMENT_WINDOW, 0);
	frame.OffsetTo(B_ORIGIN);
	psview = new PSView(BRect(0, 0, myscreen.frame.right-6-B_V_SCROLL_BAR_WIDTH,
							myscreen.frame.bottom-11-B_H_SCROLL_BAR_HEIGHT));
	myscrollview = new BScrollView("Scroll View", psview, B_FOLLOW_ALL,
			0, TRUE, TRUE, TRUE);
	myscrollview->ScrollBar(B_HORIZONTAL)->SetRange(0, 611);
	myscrollview->ScrollBar(B_VERTICAL)->SetRange(0, 791);
	mywind->AddChild(myscrollview);
	mywind->Show();
	thread_id my_thread = spawn_thread(gsloop, "GS Loop", B_NORMAL_PRIORITY, (void *)psview);
	resume_thread(my_thread);
}

long gsloop(void *psview)
{
    int code;
    code = gsdll_init(gsdll_callback, (PSView *)psview, myargc, myargv);
    fprintf(stderr, "gsdll_init returns %d\n", code);
    code = gsdll_execute_begin();
    if (code==0) {
	fprintf(stderr, "GS>");
	fflush(stderr);
	while(fgets(buf, sizeof(buf), stdin)) {
		code = gsdll_execute_cont(buf, strlen(buf));
		fprintf(stderr, "gsdll_execute returns %d\n", code);
		if (code < 0)
		    break;
		fprintf(stderr, "GS>");
		fflush(stderr);
	}
	if (!code)
		code = gsdll_execute_end();
	code = gsdll_exit();
	fprintf(stderr, "gsdll_exit returns %d\n", code);
    }

	be_app->PostMessage(B_QUIT_REQUESTED);
    return 0;
}
