/*
 * native.h
 * Native method support.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __native_h
#define __native_h

#include <jtypes.h>

/*
 * Some systems need specific exports for funcions to be shared.
 */
#if defined(__WIN32__)
#define	EXPORT(t)	t __export
#define	IMPORT(t)	extern t __import
#else
#define	EXPORT(t)	t
#define	IMPORT(t)	extern t
#endif

struct _methods;
struct _classes;
struct _thread;

/* From object.h */
#define	__object_h
typedef struct _object {
	struct _methodTable*	mtable;
	unsigned int		idx;
	unsigned int		size;
	struct _thread*		holder;
	int			count;
	struct _thread*		muxWaiters;
	struct _thread*		cvWaiters;
	int			padding;
} object;

/* From baseClasses.h */
typedef struct _stringClass {
	object		head;
	object*		value;
	int		offset;
	int		count;
} stringClass;

/* Build an object handle */
#define	HandleTo(class)					\
	struct H##class {				\
		object base;				\
		struct Class##class data[1];		\
	}

/* Turn a handle into the real thing */
#define	unhand(o)	((o)->data)

/* Some internal machine object conversions to "standard" types. */
#define	Hjava_lang_Object	_object
#define	Hjava_lang_String	_stringClass
#define	Hjava_lang_Class	_classes

/* Array types */
typedef struct { object base; struct { jbyte body[1]; } data[1]; } HArrayOfByte;
typedef struct { object base; struct { jchar body[1]; } data[1]; } HArrayOfChar;
typedef struct { object base; struct { jdouble body[1]; } data[1]; } HArrayOfDouble;
typedef struct { object base; struct { jfloat body[1]; } data[1]; } HArrayOfFloat;
typedef struct { object base; struct { jint body[1]; } data[1]; } HArrayOfInt;
typedef struct { object base; struct { jshort body[1]; } data[1]; } HArrayOfShort;
typedef struct { object base; struct { jlong body[1]; } data[1]; } HArrayOfLong;
typedef struct { object base; struct { object* body[1]; } data[1]; } HArrayOfArray;
typedef struct { object base; struct { object* body[1]; } data[1]; } HArrayOfObject;

extern char* javaString2CString(struct Hjava_lang_String*, char*, int);
extern struct Hjava_lang_String* makeJavaString(char*, int);

long	do_execute_java_method(void*, object*, char*, char*, struct _methods*, int, ...);
long	do_execute_java_class_method(char*, char*, char*, ...);
object* execute_java_constructor(void*, char*, struct _classes*, char*, ...);

void	SignalError(void*, char*, char*);

void	classname2pathname(char*, char*);

#endif
