/*
 * jtypes.h
 * Java types.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#ifndef __jtypes_h
#define __jtypes_h

#define	SIZEOF_INT	4
#define	SIZEOF_LONG	4


typedef float		jfloat;
typedef double		jdouble;
typedef	void*		jref;
typedef char		jchar;
typedef unsigned char	jbyte;
typedef short 		jshort;

#if SIZEOF_INT == 4
typedef int		jint;
#elif SIZEOF_LONG == 4
typedef long		jint;
#else
#error "sizeof(int) or sizeof(long) must be 4"
#endif

#if SIZEOF_LONG_LONG == 8
#define HAVE_NATIVE_INT64
typedef long long	jlong;
#else
typedef struct { jint jl, jh; } jlong;
#endif

#endif
