/*
 * java.net.SocketInputStream.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <native.h>
#include "../../native/java.io.stubs/FileDescriptor.h"
#include "../../native/java.io.stubs/FileInputStream.h"
#include "java.net.stubs/SocketImpl.h"
#include "java.net.stubs/SocketInputStream.h"
#include "nets.h"

jint
java_net_SocketInputStream_socketRead(struct Hjava_net_SocketInputStream* this, HArrayOfByte* buf, jint offset, jint len)
{
	int r;

	r = threadedRead(unhand(unhand(unhand(this)->impl)->fd)->fd, &unhand(buf)->body[offset], len);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}

	return (r);
}
