/*
 * java.net.PlainSocketImpl.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include "config.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#if defined(HAVE_SYS_FILIO_H)
#include <sys/filio.h>
#endif
#include <native.h>
#include "../native/java.io.stubs/FileDescriptor.h"
#include "java.net.stubs/SocketImpl.h"
#include "java.net.stubs/InetAddress.h"
#include "java.net.stubs/PlainSocketImpl.h"
#include "nets.h"

/*
 * Create a stream or datagram socket.
 */
void
java_net_PlainSocketImpl_socketCreate(struct Hjava_net_PlainSocketImpl* this, jint /* bool */ stream)
{
	int fd;
	int type;

	if (stream == 0) {
		type = SOCK_DGRAM;
	}
	else {
		type = SOCK_STREAM;
	}

	fd = threadedCreateSocket(AF_INET, type, 0);
	if (fd < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	unhand(unhand(this)->fd)->fd = fd;
}

/*
 * Connect the socket to someone.
 */
void
java_net_PlainSocketImpl_socketConnect(struct Hjava_net_PlainSocketImpl* this, struct Hjava_net_InetAddress* daddr, jint dport)
{
	int fd;
	int r;
	struct sockaddr_in addr;
	int alen;

#if defined(BSD44)
	addr.sin_len = sizeof(addr);
#endif
	addr.sin_family = AF_INET;
	addr.sin_port = htons(dport);
	addr.sin_addr.s_addr = htonl(unhand(daddr)->address);

	fd = unhand(unhand(this)->fd)->fd;
	r = threadedConnect(fd, (struct sockaddr*)&addr, sizeof(addr));
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}

	/* Enter information into socket object */
	alen = sizeof(addr);
	r = getsockname(fd, (struct sockaddr*)&addr, &alen);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}

	unhand(this)->address = daddr;
	unhand(this)->port = dport;
	unhand(this)->localport = ntohs(addr.sin_port);
}

/*
 * Bind this socket to an address.
 */
void
java_net_PlainSocketImpl_socketBind(struct Hjava_net_PlainSocketImpl* this, struct Hjava_net_InetAddress* laddr, jint lport)
{
	int r;
	struct sockaddr_in addr;

#if defined(BSD44)
	addr.sin_len = sizeof(addr);
#endif
	addr.sin_family = AF_INET;
	addr.sin_port = htons(lport);
	addr.sin_addr.s_addr = unhand(laddr)->address;

	r = bind(unhand(unhand(this)->fd)->fd, (struct sockaddr*)&addr, sizeof(addr));
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}

	/* Enter information into socket object */
	unhand(this)->address = laddr;
	unhand(this)->localport = lport;
}

/*
 * Turn this socket into a listener.
 */
void
java_net_PlainSocketImpl_socketListen(struct Hjava_net_PlainSocketImpl* this, jint count)
{
	int r;

	r = listen(unhand(unhand(this)->fd)->fd, count);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Accept a connection.
 */
void
java_net_PlainSocketImpl_socketAccept(struct Hjava_net_PlainSocketImpl* this, struct Hjava_net_SocketImpl* sock)
{
	int r;
	int alen;
	struct sockaddr_in addr;

	alen = sizeof(addr);
#if defined(BSD44)
	addr.sin_len = sizeof(addr);
#endif
	addr.sin_family = AF_INET;
	addr.sin_port = htons(unhand(sock)->port); /* localport ?? */
	addr.sin_addr.s_addr = unhand(unhand(sock)->address)->address;

	r = threadedAccept(unhand(unhand(this)->fd)->fd, (struct sockaddr*)&addr, &alen);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	unhand(unhand(sock)->fd)->fd = r;

#if not_yet_cause_i_dont_understand
	/* Enter information into socket object */
	alen = sizeof(addr);
	r = getsockname(fd, (struct sockaddr*)&addr, &alen);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}

	unhand(sock)->address = ntohl(addr.sin_addr.s_addr);
	unhand(sock)->port = ntohs(addr.sin_port);
	unhand(sock)->localport = unhand(sock)->port;
#endif
}

/*
 * Return how many bytes can be read without blocking.
 */
jint
java_net_PlainSocketImpl_socketAvailable(struct Hjava_net_PlainSocketImpl* this)
{
	int r;
	jint len;

	r = ioctl(unhand(unhand(this)->fd)->fd, FIONREAD, &len);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	return (len);
}

/*
 * Close this socket.
 */
void
java_net_PlainSocketImpl_socketClose(struct Hjava_net_PlainSocketImpl* this)
{
	int r;

	r = close(unhand(unhand(this)->fd)->fd);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}
