/*
 * java.lang.Object.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <assert.h>
#include <memory.h>
#define __jtypes_h
#include "../../kaffevm/gtypes.h"
#include <native.h>
#include "../../kaffevm/constants.h"
#include "../../kaffevm/access.h"
#include "../../kaffevm/classMethod.h"	/* Don't need java.lang.Object.h */
#include "../../kaffevm/locks.h"
#include "../../kaffevm/itypes.h"

IMPORT(struct itypes) types[];

extern object* alloc_object(classes*);
extern object* alloc_array(int, int);
extern object* alloc_objectarray(int, char*);

/*
 * Generate object hash code.
 */
long
java_lang_Object_hashCode(struct Hjava_lang_Object* o)
{
	return (o->idx);
}

/*
 * Return class object for this object.
 */
struct Hjava_lang_Class*
java_lang_Object_getClass(struct Hjava_lang_Object* o)
{
	return (o->mtable->class);
}

/*
 * Notify threads waiting here.
 */
void
java_lang_Object_notifyAll(struct Hjava_lang_Object* o)
{
	broadcastCond(o);
}

/*
 * Notify a thread waiting here.
 */
void
java_lang_Object_notify(struct Hjava_lang_Object* o)
{
	signalCond(o);
}

/*
 * Clone me.
 */
struct Hjava_lang_Object*
java_lang_Object_clone(struct Hjava_lang_Object* o)
{
	object* obj;
	char* sig;
	int type;

	sig = o->mtable->class->sig;

	if (sig[0] != '[') {
		/* Clone an object */
		obj = alloc_object(o->mtable->class);
		memcpy(obj+1, o+1, obj->mtable->class->fsize * 4);
	}
	else if (sig[1] == '[' || sig[1] == 'L') {
		/* Clone an object array */
		obj = alloc_objectarray(o->size, &sig[1]);
		memcpy(obj+1, o+1, o->size * TYPE_SIZE_C(sig[1]));
	}
	else {
		/* Clone an array */
		type = TYPE_TYPE_C(sig[1]);
		obj = alloc_array(o->size, type);
		memcpy(obj+1, o+1, o->size * TYPE_SIZE(type));
	}

	return (obj);
}

/*
 * Wait for this object to be notified.
 */
void
java_lang_Object_wait(struct Hjava_lang_Object* o, jlong timeout)
{
	waitCond(o, timeout);
}
