/*
 * java.io.File.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <native.h>
#if defined(HAVE_DIR_H)
#include <dir.h>
#endif
#include "defs.h"
#include "files.h"
#include "system.h"
#include "java.io.stubs/File.h"

/*
 * Is named item a file?
 */
jint /* bool */
java_io_File_isFile0(struct Hjava_io_File* this)
{
	struct stat buf;
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	r = stat(str, &buf);
	if (r == 0 && S_ISREG(buf.st_mode)) {
		return (1);
	}
	else {
		return (0);
	}
}

/*
 * Is named item a directory?
 */
jint /* bool */
java_io_File_isDirectory0(struct Hjava_io_File* this)
{
	struct stat buf;
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	r = stat(str, &buf);
	if (r == 0 & S_ISDIR(buf.st_mode)) {
		return (1);
	}
	else {
		return (0);
	}
}

/*
 * Does named file exist?
 */
jint /* bool */
java_io_File_exists0(struct Hjava_io_File* this)
{
	struct stat buf;
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	r = stat(str, &buf);
	if (r < 0) {
		return (0);
	}
	else {
		return (1);
	}
}

/*
 * Last modified time on file.
 */
jlong
java_io_File_lastModified0(struct Hjava_io_File* this)
{
	struct stat buf;
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	r = stat(str, &buf);
	if (r != 0) {
		return (off_t2jlong(0));
	}
#if defined(HAVE_NATIVE_INT64)
	return (buf.st_mtime * (jlong)1000);
#else
	return (off_t2jlong(buf.st_mtime * 1000));	/* HACK */
#endif
}

/*
 * Can I write to this file?
 */
jint /* bool */
java_io_File_canWrite0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
	r = access(str, W_OK);
	return (r == 0 ? 1 : 0);
}

/*
 * Can I read from this file.
 */
jint /* bool */
java_io_File_canRead0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
	r = access(str, R_OK);
	return (r == 0 ? 1 : 0);
}

/*
 * Return length of file.
 */
jlong
java_io_File_length0(struct Hjava_io_File* this)
{
	struct stat buf;
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	r = stat(str, &buf);
	return (off_t2jlong(r == 0 ? buf.st_size : 0));
}

/*
 * Create a directory.
 */
jint /* bool */
java_io_File_mkdir0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
#if defined(__WIN32__)
	r = mkdir(str);
#else
	r = mkdir(str, 0777);
#endif
	return (r);
}

/*
 * Rename a file.
 */
jint /* bool */
java_io_File_renameTo0(struct Hjava_io_File* this, struct Hjava_io_File* that)
{
	char str[MAXPATHLEN];
	char str2[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
	javaString2CString(unhand(that)->path, str2, sizeof(str2));

	r = rename(str, str2);
	return (r);
}

/*
 * Delete a file.
 */
jint /* bool */
java_io_File_delete0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
	r = remove(str);
	return(r);
}

/*
 * Get a directory listing (I think)
 */
HArrayOfObject* /* [Ljava.lang.String; */
java_io_File_list0(struct Hjava_io_File* this)
{
	abort();
	return (0);
}

/*
 * Is this filename absolute?
 */
jint /* bool */
java_io_File_isAbsolute(struct Hjava_io_File* this)
{
	char str[1];

	javaString2CString(unhand(this)->path, str, sizeof(str));

	if (str[0] == file_seperator[0]) {
		return (1);
	}
	else {
		return (0);
	}
}
