/*
 * soft.h
 * Soft instruction prototypes.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *                 City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, May 1996.
 */

#ifndef __soft_h
#define	__soft_h

struct _methodTable;
struct _strpair;
struct _classes;
struct _object;

void*	soft_new(struct _classes*);
void*	soft_anewarray(struct _classes*, jint);
void*	soft_newarray(jint, jint);

void	soft_monitorenter(struct _object*);
void	soft_monitorexit(struct _object*);

void*	soft_lookupmethod(struct _methodTable*, struct _strpair*);
void	soft_checkcast(struct _classes*, struct _object*);
jint	soft_instanceof(struct _classes*, struct _object*);

void	soft_athrow(struct _object*);
void	soft_badarrayindex(void);

jint	soft_dcmpg(jdouble, jdouble);
jint	soft_dcmpl(jdouble, jdouble);
jint	soft_fcmpg(jfloat, jfloat);
jint	soft_fcmpl(jfloat, jfloat);

#if defined(INTERPRETER)
void*	soft_multianewarray(struct _classes*, jint, slots*);
#endif

#if defined(TRANSLATOR)
jlong	soft_lmul(jlong, jlong);
jlong	soft_ldiv(jlong, jlong);
jlong	soft_lrem(jlong, jlong);
jfloat	soft_frem(jfloat, jfloat);
jdouble	soft_freml(jdouble, jdouble);
jlong	soft_lshll(jlong, jint);
jlong	soft_ashrl(jlong, jint);
jlong	soft_lshrl(jlong, jint);
jint	soft_lcmp(jlong, jlong);
void*	soft_multianewarray(struct _classes*, jint, ...);
#endif

#if !defined(HAVE_NATIVE_INT64)
jlong	soft_moveconst(jint);
jlong	soft_ladd(jlong, jlong);
jlong	soft_lsub(jlong, jlong);
jlong	soft_lmul(jlong, jlong);
jlong	soft_ldiv(jlong, jlong);
jlong	soft_lrem(jlong, jlong);
jlong	soft_lneg(jlong);
jlong	soft_land(jlong, jlong);
jlong	soft_lor(jlong, jlong);
jlong	soft_lxor(jlong, jlong);
jlong	soft_llshl(jlong, jint);
jlong	soft_lashr(jlong, jint);
jlong	soft_llshr(jlong, jint);
jint	soft_lcmp(jlong, jlong);
jlong	soft_cvtil(jint);
jint	soft_cvtli(jlong);
jfloat	soft_cvtlf(jlong);
jdouble	soft_cvtld(jlong);
jlong	soft_cvtfl(jfloat);
jlong	soft_cvtdl(jdouble);
#endif

#endif
