/* slib.h
 * Macro'ise the shared library calls to be 'portable'.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *                 City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, May 1996.
 */

#ifndef __slib_h
#define __slib_h

#if defined(HAVE_DLFCN_H) 
#include <dlfcn.h>
#endif

#if defined(__WIN32__)
#define dlopen(s, m)    LoadLibrary(s)
#define dlsym(l, s)     GetProcAddress(l, s)
#endif 

#endif
