/*
 * readClass.h
 * Various bits of information in a Java class file.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __readclass_h
#define __readclass_h

#define	JAVAMAGIC	0xCafeBabe
#define	MAJOR_VERSION	45
#define	MINOR_VERSION	3

typedef struct _field_info {
	u2		access_flags;
	u2		name_index;
	u2		signature_index;
} field_info;

typedef struct _method_info {
	u2		access_flags;
	u2		name_index;
	u2		signature_index;
} method_info;

struct _classes;
struct _methods;

void readClass(classFile*);
void readInterfaces(classFile*, struct _classes*);
void readMethods(classFile*, struct _classes*);
void readFields(classFile*, struct _classes*);
void readAttributes(classFile*, struct _classes*, struct _methods*);

#endif
