/*
 * lookup.h
 * Various lookup calls for resolving objects, methods, exceptions, etc.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __lookup_h
#define __lookup_h

struct _methodTable;

typedef struct _callInfo {
	int			in;
	int			out;
	struct _methodTable*	mtable;
	int			offset;
	int			mtag;
	char*			type;
	char			rettype;
} callInfo;

typedef struct _createInfo {
	struct _classes*	class;
} createInfo;

typedef struct _fieldInfo {
	struct _classes*	class;
	int			size;
	int			offset;
} fieldInfo;

typedef struct _exceptionInfo {
	int			handler;
	struct _classes*	class;
} exceptionInfo;

void	getMethodSignatureClass(constIndex, constants*, callInfo*);
void	getClass(constIndex, constants*, createInfo*);
void	getField(constIndex, bool, constants*, fieldInfo*);
void*	findMethod(classes*, strpair*);
void	findExceptionInMethod(uintp, classes*, exceptionInfo*);
bool	findExceptionBlockInMethod(uintp, classes*, methods*, exceptionInfo*);

#endif
