/* slots.h
 * Slots.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#ifndef __slots_h
#define __slots_h

#define	Tcomplex		0
#define	Tnull			Tcomplex
#define	Tconst			1
#define	Tcopy			2
#define	Taddregconst		3
#define	Tstore			4
#define	Tload			5

#define	MAXSLOT			128
#define	NOSLOT			0

/* Return slots */
#define	returnInt		0
#define	returnRef		0
#define	returnLong		0 /* 1 */
#define	returnFloat		2
#define	returnDouble		2 /* 3 */
#define	MAXRETURNS		4

struct _slots;

typedef struct _slots {
	union {
		jint		tint;
		jlong		tlong;
		jdouble		tdouble;
		void*		taddr;
		char*		tstr;
	} v;
	int			type;
	struct _sequence*	insn;
	int			regno;
	int			modified;
	struct _sequence*	where;
} slots;

extern slots slotinfo[];
extern slots* returninfo;
extern slots* localinfo;
extern slots* stackinfo;
extern slots* tempinfo;
extern int tmpslot;
extern int stackno;

void initSlots(void);
void markReturns(void);

/* Slot access macros */

#define	stack(_s)		(&stackinfo[stackno+(_s)])
#define	local(_s)		(&localinfo[(_s)])
#define	local_long(_s)		(&localinfo[(_s)])
#define	local_float		local
#define	local_double		local_long

#define	slot_return(s)		((s) >= &returninfo[0] &&		\
				 (s) < &returninfo[MAXRETURNS])

#define	slot_value(s)		(s)->v.value
#define	slot_fvalue(s)		(s)->v.fvalue

#define	slot_const(s)		((s)->type == Tconst)

#define	slot_addregconst(s)	((s)->type == Taddregconst)

#define	slot_alloctmp(t)	(t) = &tempinfo[tmpslot],		\
				tmpslot += 1
#define	slot_alloc2tmp(t)	(t) = &tempinfo[tmpslot],		\
				tmpslot += 2

#define	slot_invalidate(s)	(s)->regno = NOREG;			\
				(s)->modified = 0

#endif
