/* seq.h
 * Pseudo instruction sequences.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#ifndef __seq_hh
#define __seq_hh

struct _sequence;

typedef void (*ifunc)(struct _sequence*);

typedef struct _sequence {
	ifunc			func;
	int			ref;
	union {
		struct _slots*	slot;
		jint		iconst;
		jlong		lconst;
		jdouble		fconst;
	} u[3];
	struct _sequence*	next;
} sequence;

void initSeq(void);
sequence* nextSeq(void);

extern sequence*		firstSeq;
extern sequence*		lastSeq;
extern sequence*		currSeq;

#define	ALLOCSEQNR		128

#define	seq(s)			((s)->insn)

#define	seq_dst(s)		seq_src(0, s)
#define	seq_src(i, s)		((s)->u[i].slot)
#define	seq_src_value(i, s)	((s)->u[i].iconst)

#endif
