/* registers.h
 * Instruction macros to extract information.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#ifndef __registers_h
#define __registers_h

#define	Reserved		0x00
#define	Rint			0x01
#define	Rlong			0x02
#define	Rfloat			0x04
#define	Rdouble			0x08
#define	Rref			0x10

typedef struct _kregs {
	struct _slots*		slot;
	uint8			ctype;
	uint8			type;
	uint8			readonce;
	uint32			used;
} kregs;

extern kregs reginfo[];

#define	register_invalidate(r)	reginfo[r].slot = NOSLOT

#define	MAXREG			NR_REGISTERS
#define	NOREG			MAXREG

#define	SLOT2FRAMEOFFSET(_s)					\
	(((_s) - slotinfo < maxArgs) ? 				\
		SLOT2ARGOFFSET((_s) - slotinfo + isStatic) :	\
		SLOT2LOCALOFFSET((_s) - slotinfo))

void	spill(slots*);
void	reload(slots*);

int	slowSlotRegister(slots*, int, int);
void	clobberRegister(int);
void	forceRegister(slots*, int, int);

#define	rread			1
#define	rwrite			2

#define	rreg_int(i)		slowSlotRegister(s->u[i].slot, Rint, rread)
#define	wreg_int(i)		slowSlotRegister(s->u[i].slot, Rint, rwrite)
#define	rwreg_int(i)		slowSlotRegister(s->u[i].slot, Rint, rread|rwrite)
#define	rslot_int(i)		slowSlotOffset(s->u[i].slot, Rint, rread)
#define	wslot_int(i)		slowSlotOffset(s->u[i].slot, Rint, rwrite)
#define	const_int(i)		s->u[i].iconst

#define	rreg_long(i)		slowSlotRegister(s->u[i].slot, Rlong, rread)
#define	wreg_long(i)		slowSlotRegister(s->u[i].slot, Rlong, rwrite)
#define	rslot_long(i)		slowSlotOffset(s->u[i].slot, Rlong, rread)
#define	rslot_long(i)		slowSlotOffset(s->u[i].slot, Rlong, rread)
#define	wslot_long(i)		slowSlotOffset(s->u[i].slot, Rlong, rwrite)

#define	rreg_float(i)		slowSlotRegister(s->u[i].slot, Rfloat, rread)
#define	wreg_float(i)		slowSlotRegister(s->u[i].slot, Rfloat, rwrite)
#define	rslot_float(i)		slowSlotOffset(s->u[i].slot, Rfloat, rread)
#define	wslot_float(i)		slowSlotOffset(s->u[i].slot, Rfloat, rwrite)
#define	const_float(i)		s->u[i].fconst

#define	rreg_double(i)		slowSlotRegister(s->u[i].slot, Rdouble, rread)
#define	wreg_double(i)		slowSlotRegister(s->u[i].slot, Rdouble, rwrite)
#define	rslot_double(i)		slowSlotOffset(s->u[i].slot, Rdouble, rread)
#define	wslot_double(i)		slowSlotOffset(s->u[i].slot, Rdouble, rwrite)
#define	const_double(i)		s->u[i].fconst

#endif
