/* labels.h
 * Manage the labelling system.  These are used to provide the necessary
 * interlinking of branches and subroutine calls.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#ifndef __label_h
#define __label_h

#define	Lnull		0x00	/* Unused label */

#define	Llong		0x01	/* Label is long (32 bits) */

#define	Lgeneral	0x00	/* Label reference general code */
#define	Lcode		0x10	/* Label references bytecode offset */

#define	Lexternal	0x00	/* Label references external routine */
#define	Linternal	0x20	/* Label references internal routine */

#define	Labsolute	0x00	/* Absolute value */
#define	Lrelative	0x40	/* Relative value to place of insertion */

typedef struct _label_ {
	uintp		at;
	uintp		to;
	uintp		from;
	uint8		type;
	struct _label_*	next;
} label;

#define	ALLOCLABELNR	32

label* nextLabel(void);

#endif
