/* labels.c
 * Manage the code labels and links.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#include <assert.h>
#include <stdlib.h>
#include "gtypes.h"
#include "labels.h"
#include "codeinfo.h"

extern uintp realcodediff;

label* firstLabel;
label* lastLabel;
label* currLabel;

void
linkLabels(void)
{
	uintp dest;
	uintp from;
	uintp* place;
	label* l;

	for (l = firstLabel; l != currLabel; l = l->next) {

		if ((l->type & Llong) != Llong) {
			printf("Label not long (%x).\n", l);
			abort();
		}

		/* Find destination of jump */
		if (l->type & Lcode) {
			assert(code[l->to].pc != (uintp)-1);
			dest = code[l->to].pc;
		}
		else {
			dest = l->to;
		}

		/* If internal destination, adjust it */
		if (l->type & Linternal) {
			dest += realcodediff;
		}

		/* Find place to store result */
		place = (uintp*)(l->at + realcodediff);

		/* If label is relative, find where it is relative to */
		if (l->type & Lrelative) {
			from = l->from + realcodediff;
		}
		else {
			from = 0;
		}

		/* Install result */
		(*place) = dest - from;
	}

	/* Reset labels */
	currLabel = firstLabel;
}

/*
 * Allocate a new label.
 */
label*
nextLabel(void)
{
	int i;
	label* ret = currLabel;

	if (ret == 0) {
		/* Allocate chunk of label elements */
		ret = calloc(ALLOCLABELNR, sizeof(label));
		assert(ret != 0);

		/* Attach to current chain */
		if (lastLabel == 0) {
			firstLabel = ret;
		}
		else {
			lastLabel->next = ret;
		}
		lastLabel = &ret[ALLOCLABELNR-1];

		/* Link elements into list */
		for (i = 0; i < ALLOCLABELNR-1; i++) {
			ret[i].next = &ret[i+1];
		}
		ret[ALLOCLABELNR-1].next = 0;
	}
	currLabel = ret->next;
	return (ret);
}
