/* basecode.h
 * Define the base instructions macros.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#ifndef __basecode_h
#define __basecode_h

extern int argcount;

/* -------------------------------------------------------------------- */
/* Branches */

#define	ba			0	/* Always */
#define	beq			1	/* Equal */
#define	blt			2	/* Less than */
#define	ble			3	/* Less than or equal */
#define	bgt			4	/* Greater than */
#define	bge			5	/* Greater than or equal */
#define	bne			6	/* Not equal */
#define	bn			7	/* Never */

#define	invert_branch(b)	(7-(b))

#define	bindirect		8	/* Indirect */

/* -------------------------------------------------------------------- */
/* Basic blocks and instructions */

#define	start_instruction()	_start_instruction(pc)
#define	start_function()	prologue()
#define	start_basic_block()	_start_basic_block(npc, stackno)
#define	end_basic_block()	_end_basic_block(npc, stackno)
#define	end_function()		epilogue()
#define	start_exception_block()	_start_exception_block(stackno)

/* -------------------------------------------------------------------- */
/* Conditional monitors */

#define	monitor_enter()		mon_enter(meth, local(0))
#define	monitor_exit()		mon_exit(meth, local(0))

/* -------------------------------------------------------------------- */
/* Instruction formats */

#define	soft_call_int(dst, src, src2, func)				\
	soft_call_gen(dst, src, src2, func, int)

#define	soft_call_long(dst, src, src2, func)				\
	soft_call_gen(dst, src, src2, func, long)

#define	soft_call_float(dst, src, src2, func)				\
	soft_call_gen(dst, src, src2, func, float)

#define	soft_call_double(dst, src, src2, func)				\
	soft_call_gen(dst, src, src2, func, double)

#define	soft_call_ref(dst, src, src2, func)				\
	soft_call_gen(dst, src, src2, func, ref)

#define	soft_call_gen(dst, src, src2, func, type)			\
	{								\
		end_basic_block();					\
		if (src2 != 0) {					\
			pusharg_##type(src2);				\
		}							\
		if (src != 0) {						\
			pusharg_##type(src);				\
		}							\
		call_ref((uintp)func);					\
		popargs(2 * sizeof(j##type) / sizeof(int));		\
		start_basic_block();					\
		if (dst != 0) {						\
			return_##type(dst);				\
		}							\
	}


#define	slot_const_const(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_slot_const_const((dst), (src), (src2), (func), (t));	\
	}

#define	slot_slot_const(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_slot_slot_const((dst), (src), (src2), (func), (t));	\
	}

#define	slot_slot_fconst(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_slot_slot_fconst((dst), (src), (src2), (func), (t));	\
	}

#define	slot_slot_slot(dst, src, src2, func, t)				\
	{								\
		void func(sequence*);					\
		_slot_slot_slot((dst), (src), (src2), (func), (t));	\
	}

#define	lslot_slot_lconst(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_lslot_slot_lconst((dst), (src), (src2), (func), (t));	\
	}

#define	lslot_slot_fconst(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_lslot_slot_fconst((dst), (src), (src2), (func), (t));	\
	}

#define	lslot_lslot_lslot(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_lslot_lslot_lslot((dst), (src), (src2), (func), (t));	\
	}

#define	lslot_lslot_slot(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_lslot_lslot_slot((dst), (src), (src2), (func), (t));	\
	}

#define	slot_slot_lslot(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_slot_slot_lslot((dst), (src), (src2), (func), (t));	\
	}

/* -------------------------------------------------------------------- */

#endif
