/* basecode.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#define	CDBG(s)

#include <assert.h>
#include "gtypes.h"
#include "slots.h"
#include "seq.h"
#include "registers.h"
#include "icode.h"
#include "basecode.h"
#include "md.h"
#include "flags.h"

/* Modify references */
#define	CLRREF(_s)	if ((_s) && (_s)->insn) {	\
				(_s)->insn->ref = 0;	\
			}
#define	INCREF(_s)	if ((_s) && (_s)->insn) {	\
				(_s)->insn->ref++;	\
			}
#define	LCLRREF(_s)	if ((_s) && (_s)->insn) {	\
				(_s)[0].insn->ref = 0;	\
			}
#define	LINCREF(_s)	if ((_s) && (_s)->insn) {	\
				(_s)[0].insn->ref++;	\
			}
#define	ASSIGNSLOT(_d, _s)				\
			(_d).slot = (_s)

void
_cancel_insn(slots* dst)
{
CDBG(	printf("Cancel 0x%x\n", dst);			)
	dst->insn->func = 0;
}

void
_slot_const_const(slots* dst, int s1, int s2, ifunc f, int type)
{
	sequence* seq = nextSeq();

	seq->u[1].iconst = s1;
	seq->u[2].iconst = s2;
	ASSIGNSLOT(seq->u[0], dst);
	if (dst != 0) {
		dst->insn = seq;
		dst->type = type;
		dst->where = 0;
		CLRREF(dst);
	}

	seq->func = f;
}

void
_slot_slot_const(slots* dst, slots* s1, int s2, ifunc f, int type)
{
	sequence* seq = nextSeq();

	ASSIGNSLOT(seq->u[1], s1);
	seq->u[2].iconst = s2;
	ASSIGNSLOT(seq->u[0], dst);
	INCREF(s1);
	if (dst != 0) {
		dst->insn = seq;
		dst->type = type;
		dst->where = 0;
		CLRREF(dst);
	}

	seq->func = f;
}

void
_slot_slot_fconst(slots* dst, slots* s1, double s2, ifunc f, int type)
{
	sequence* seq = nextSeq();

	ASSIGNSLOT(seq->u[1], s1);
	seq->u[2].fconst = s2;
	ASSIGNSLOT(seq->u[0], dst);
	INCREF(s1);
	if (dst != 0) {
		dst->insn = seq;
		dst->type = type;
		dst->where = 0;
		CLRREF(dst);
	}

	seq->func = f;
}

void
_slot_slot_slot(slots* dst, slots* s1, slots* s2, ifunc f, int type)
{
	sequence* seq;
#if defined(TWO_OPERAND)
	slots* olddst = 0;

	/* Two operand systems cannot handle three operand ops.
	 * We need to fixit so the dst is one of the source ops.
	 */
	if (s1 != 0 && s2 != 0 && dst != 0) {
		if (s2 == dst) {
			olddst = dst;
			slot_alloctmp(dst);
		}
		if (s1 != dst) {
			move_any(dst, s1);
			s1 = dst;
		}
	}
#endif
	seq = nextSeq();

	INCREF(s1);
	INCREF(s2);

	/*
	 * Optimise operands to eliminate addition moves.
	 */
	if (flag_optimise) {
		if (dst != 0 && dst->insn != 0 && dst->insn->ref == 0) {
			_cancel_insn(dst);
		}
	}

	ASSIGNSLOT(seq->u[1], s1);
	ASSIGNSLOT(seq->u[2], s2);
	ASSIGNSLOT(seq->u[0], dst);
	if (dst != 0) {
		dst->insn = seq;
		dst->type = type;
		if (type == Tcopy) {
			dst->where = s2->insn;
		}
		else {
			dst->where = 0;
		}
		CLRREF(dst);
	}

	seq->func = f;

#if defined(TWO_OPERAND)
	if (olddst != 0) {
		move_any(olddst, dst);
	}
#endif
}

void
_lslot_lslot_lslot(slots* dst, slots* s1, slots* s2, ifunc f, int type)
{
	sequence* seq;
#if defined(TWO_OPERAND)
	/* Two operand systems cannot handle three operand ops.
	 * We need to fixit so the dst is one of the source ops.
	 */
	slots* olddst = 0;
	if (s1 != 0 && s2 != 0 && dst != 0) {
		if (s2 == dst) {
			olddst = dst;
			slot_alloc2tmp(dst);
		}
		if (s1 != dst) {
			move_anylong(dst, s1);
			s1 = dst;
		}
	}
#endif
	seq = nextSeq();

	ASSIGNSLOT(seq->u[1], s1);
	ASSIGNSLOT(seq->u[2], s2);
	ASSIGNSLOT(seq->u[0], dst);
	LINCREF(s1);
	LINCREF(s2);
	if (dst != 0) {
		dst[0].insn = seq;
		dst[0].type = type;
		dst[0].where = 0;
		dst[1].insn = 0;
		dst[1].type = Tnull;
		dst[1].where = 0;
		LCLRREF(dst);
	}

	seq->func = f;

	if (olddst != 0) {
		move_anylong(olddst, dst);
	}
}

void
_lslot_lslot_slot(slots* dst, slots* s1, slots* s2, ifunc f, int type)
{
	sequence* seq;
#if defined(TWO_OPERAND)
	/* Two operand systems cannot handle three operand ops.
	 * We need to fixit so the dst is one of the source ops.
	 */
	slots* olddst = 0;
	if (s1 != 0 && s2 != 0 && dst != 0) {
		if (s2 == dst) {
			olddst = dst;
			slot_alloctmp(dst);
		}
		if (s1 != dst) {
			move_any(dst, s1);
			s1 = dst;
		}
	}
#endif
	seq = nextSeq();

	ASSIGNSLOT(seq->u[1], s1);
	ASSIGNSLOT(seq->u[2], s2);
	ASSIGNSLOT(seq->u[0], dst);
	LINCREF(s1);
	INCREF(s2);
	if (dst != 0) {
		dst[0].insn = seq;
		dst[0].type = type;
		dst[0].where = 0;
		dst[1].insn = 0;
		dst[1].type = Tnull;
		dst[1].where = 0;
		LCLRREF(dst);
	}

	seq->func = f;

#if defined(TWO_OPERAND)
	if (olddst != 0) {
		move_any(olddst, dst);
	}
#endif
}

void
_slot_slot_lslot(slots* dst, slots* s1, slots* s2, ifunc f, int type)
{
	sequence* seq;
#if defined(TWO_OPERAND)
	/* Two operand systems cannot handle three operand ops.
	 * We need to fixit so the dst is one of the source ops.
	 */
	slots* olddst = 0;
	if (s1 != 0 && s2 != 0 && dst != 0) {
		if (s2 == dst) {
			olddst = dst;
			slot_alloctmp(dst);
		}
		if (s1 != dst) {
			move_any(dst, s1);
			s1 = dst;
		}
	}
#endif
	seq = nextSeq();

	ASSIGNSLOT(seq->u[1], s1);
	ASSIGNSLOT(seq->u[2], s2);
	ASSIGNSLOT(seq->u[0], dst);
	INCREF(s1);
	LINCREF(s2);
	if (dst != 0) {
		dst->insn = seq;
		dst->type = type;
		if (type == Tcopy) {
			dst->where = s2->insn;
		}
		else {
			dst->where = 0;
		}
		CLRREF(dst);
	}

	seq->func = f;

#if defined(TWO_OPERAND)
	if (olddst != 0) {
		move_any(olddst, dst);
	}
#endif
}

void
_lslot_slot_lconst(slots* dst, slots* s1, jlong s2, ifunc f, int type)
{
	sequence* seq = nextSeq();

	ASSIGNSLOT(seq->u[1], s1);
	seq->u[2].lconst = s2;
	ASSIGNSLOT(seq->u[0], dst);
	INCREF(s1);
	if (dst != 0) {
		dst[0].insn = seq;
		dst[0].type = type;
		dst[0].where = 0;
		dst[1].insn = 0;
		dst[1].type = Tnull;
		dst[1].where = 0;
		LCLRREF(dst);
	}

	seq->func = f;
}

void
_lslot_slot_fconst(slots* dst, slots* s1, double s2, ifunc f, int type)
{
	sequence* seq = nextSeq();

	ASSIGNSLOT(seq->u[1], s1);
	seq->u[2].fconst = s2;
	ASSIGNSLOT(seq->u[0], dst);
	INCREF(s1);
	if (dst != 0) {
		dst[0].insn = seq;
		dst[0].type = type;
		dst[0].where = 0;
		dst[1].insn = 0;
		dst[1].type = Tnull;
		dst[1].where = 0;
		LCLRREF(dst);
	}

	seq->func = f;
}
