/*
 * itypes.h
 * Internal types.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __itypes_h
#define __itypes_h

#define	TYPE_Boolean	4
#define	TYPE_Char	5
#define	TYPE_Float	6
#define	TYPE_Double	7
#define	TYPE_Byte	8
#define	TYPE_Short	9
#define	TYPE_Int	10
#define	TYPE_Long	11
#define	TYPE_Bad	17

#define	MAXTYPES	16

struct itypes {
	int	size;
	char*	arraySig;
};

#define	TYPE_SIZE(t)		types[t].size
#define	TYPE_ARRAYSIG(t)	types[t].arraySig
#define	TYPE_SIZE_C(c)						\
	((c) == 'Z' ? types[TYPE_Boolean].size :		\
	(c) == 'C' ? types[TYPE_Char].size :			\
	(c) == 'F' ? types[TYPE_Float].size :			\
	(c) == 'D' ? types[TYPE_Double].size :			\
	(c) == 'B' ? types[TYPE_Byte].size :			\
	(c) == 'S' ? types[TYPE_Short].size :			\
	(c) == 'I' ? types[TYPE_Int].size :			\
	(c) == 'J' ? types[TYPE_Long].size : 4)

#define	TYPE_TYPE_C(c)						\
	((c) == 'Z' ? TYPE_Boolean :				\
	(c) == 'C' ? TYPE_Char :				\
	(c) == 'F' ? TYPE_Float :				\
	(c) == 'D' ? TYPE_Double :				\
	(c) == 'B' ? TYPE_Byte :				\
	(c) == 'S' ? TYPE_Short :				\
	(c) == 'I' ? TYPE_Int :					\
	(c) == 'J' ? TYPE_Long : TYPE_Bad)

#endif
