/*
 * slots.h
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *                 City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, May 1996.
 */

#ifndef __slots_h
#define	__slots_h

typedef struct _slots {
	union {
		jint		tint;
		jlong		tlong;
		jfloat		tfloat;
		jdouble		tdouble;
		void*		taddr;
		char*		tstr;
	} v;
} slots;

#define	push(_n)	sp -= (_n)
#define	pop(_n)		sp += (_n)
#define	stack(_n)	(&lcl[meth->localsz+sp+(_n)])
#define	local(_n)	(&lcl[(_n)])
#define local_long(_n)	(&lcl[(_n)+1])
#define local_float	local
#define local_double	local_long

#define	slot_alloctmp(s) /* Does nothing for interpreter */

#endif
