/*
 * machine.h
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *                 City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, May 1996.
 */

#ifndef __machine_h
#define	__machine_h

#define	constants()		(meth->constants)
#define	constant(_idx)							\
	(constants()->tags[_idx] == CONSTANT_Chararray ?		\
		makeStringObject(_idx, constants()) :			\
		&constants()->data[_idx])
	
#define	constant_long(_idx)						\
		&constants()->data[_idx]

#define getpc(n)		(code[pc+1+(n)])
#define getcode(n)		(code[(n)])

#define	object_array_offset	(OBJECT_DATA)
#define	object_array_length	(OBJECT_SIZE)

#define	get_method_info(_cnst, _idx) \
	getMethodSignatureClass(_idx, _cnst, &cinfo)

#define	method_name()		((strpair*)cinfo.mtag)
#define	method_table()		((slots*)&cinfo.mtable)
#define method_tag()		(cinfo.mtag)
#define method_hash()		(cinfo.offset)
#define	method_nargs()		(cinfo.in)
#define	method_table_offset	OBJECT_MTABLE
#define	method_returntype()	(cinfo.rettype)

#define	get_field_info(_cnst, _idx) \
	getField(_idx, false, _cnst, &flinfo)

#define	get_static_field_info(_cnst, _idx) \
	getField(_idx, true, _cnst, &flinfo)

#define	field_size()		(flinfo.size)
#define	field_data()		(OBJECT_DATA)
#define	field_offset()		(flinfo.offset * 4)
#define	field_statics()		((uintp)flinfo.class->staticFields)

#define	get_class_info(_cnst, _idx) \
	getClass(_idx, _cnst, &crinfo)

#define	class_object()		((slots*)&crinfo.class)

#define	switchpair_size		8
#define	switchpair_addr		4
#define	switchtable_size	4

struct _methods;
void virtualMachine(struct _methods*, slots*);

#endif
