/*
 * code.h
 * Define the instruction codes macros.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *                 City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, May 1996.
 */

#ifndef __code_h
#define	__code_h

#include "config.h"

#if defined(HAVE_REMAINDER)
#elif defined(HAVE_FMOD)
#define	remainder fmod
#else
#error "Need some form of remainder"
#endif
#if !defined(HAVE_REMAINDERF)
#define	remainderf(a, b) (float)remainder((double)a, (double)b)
#endif


/*
 * Some compilers do not have internal support for 64bit integers
 */
#if defined(HAVE_NATIVE_INT64)

#define	move_long_const(t, c)			(t)[0].v.tlong = (c)
#define	add_long(t, f1, f2)			(t)[0].v.tlong = (f1)[0].v.tlong + (f2)[0].v.tlong
#define	sub_long(t, f1, f2)			(t)[0].v.tlong = (f1)[0].v.tlong - (f2)[0].v.tlong
#define	mul_long(t, f1, f2)			(t)[0].v.tlong = (f1)[0].v.tlong * (f2)[0].v.tlong
#define	div_long(t, f1, f2)			(t)[0].v.tlong = (f1)[0].v.tlong / (f2)[0].v.tlong
#define	rem_long(t, f1, f2)			(t)[0].v.tlong = (f1)[0].v.tlong % (f2)[0].v.tlong
#define	neg_long(t, f)				(t)[0].v.tlong = -(f)[0].v.tlong

#define	and_long(t, f1, f2)			(t)[0].v.tlong = (f1)[0].v.tlong & (f2)[0].v.tlong
#define	or_long(t, f1, f2)			(t)[0].v.tlong = (f1)[0].v.tlong | (f2)[0].v.tlong
#define	xor_long(t, f1, f2)			(t)[0].v.tlong = (f1)[0].v.tlong ^ (f2)[0].v.tlong

#define	lshl_long(t, f1, f2)			(t)[0].v.tlong = ((f1)[0].v.tlong) << ((f2)[0].v.tint & 63)
#define	ashr_long(t, f1, f2)			(t)[0].v.tlong = ((int64)(f1)[0].v.tlong) >> ((f2)[0].v.tint & 63)
#define	lshr_long(t, f1, f2)			(t)[0].v.tlong = ((uint64)(f1)[0].v.tlong) >> ((f2)[0].v.tint & 63)

#define	cmp_long(t, f1, f2)			lcc = ((f2)[0].v.tlong) - ((f1)[0].v.tlong); \
						(t)[0].v.tint = (lcc < 0 ? -1 : lcc > 0 ? 1 : 0)


#define	cvt_int_long(t, f)			(t)[0].v.tlong = (f)[0].v.tint
#define	cvt_long_int(t, f)			(t)[0].v.tint = (f)[0].v.tlong
#define	cvt_long_float(t, f)			(t)[0].v.tfloat = (f)[0].v.tlong
#define	cvt_long_double(t, f)			(t)[0].v.tdouble = (f)[0].v.tlong
#define	cvt_float_long(t, f)			(t)[0].v.tlong = (f)[0].v.tfloat
#define	cvt_double_long(t, f)			(t)[0].v.tlong = (f)[0].v.tdouble

#else

#define	move_long_const(t, c)			(t)[0].v.tlong = soft_moveconst((c))
#define	add_long(t, f1, f2)			(t)[0].v.tlong = soft_ladd((f1)[0].v.tlong, (f2)[0].v.tlong)
#define	sub_long(t, f1, f2)			(t)[0].v.tlong = soft_lsub((f1)[0].v.tlong, (f2)[0].v.tlong)
#define	mul_long(t, f1, f2)			(t)[0].v.tlong = soft_lmul((f1)[0].v.tlong, (f2)[0].v.tlong)
#define	div_long(t, f1, f2)			(t)[0].v.tlong = soft_ldiv((f1)[0].v.tlong, (f2)[0].v.tlong)
#define	rem_long(t, f1, f2)			(t)[0].v.tlong = soft_lrem((f1)[0].v.tlong, (f2)[0].v.tlong)
#define	neg_long(t, f)				(t)[0].v.tlong = soft_lneg((f)[0].v.tlong)

#define	and_long(t, f1, f2)			(t)[0].v.tlong = soft_land((f1)[0].v.tlong, (f2)[0].v.tlong)
#define	or_long(t, f1, f2)			(t)[0].v.tlong = soft_lor((f1)[0].v.tlong, (f2)[0].v.tlong)
#define	xor_long(t, f1, f2)			(t)[0].v.tlong = soft_lxor((f1)[0].v.tlong, (f2)[0].v.tlong)

#define	lshl_long(t, f1, f2)			(t)[0].v.tlong = soft_llshl(((f1)[0].v.tlong), ((f2)[0].v.tint & 63))
#define	ashr_long(t, f1, f2)			(t)[0].v.tlong = soft_lashr(((f1)[0].v.tlong), ((f2)[0].v.tint & 63))
#define	lshr_long(t, f1, f2)			(t)[0].v.tlong = soft_llshr(((f1)[0].v.tlong), ((f2)[0].v.tint & 63))

#define	cmp_long(t, f1, f2)			(t)[0].v.tint = soft_lcmp(((f2)[0].v.tlong), ((f1)[0].v.tlong))

#define	cvt_int_long(t, f)			(t)[0].v.tlong = soft_cvtil((f)[0].v.tint)
#define	cvt_long_int(t, f)			(t)[0].v.tint = soft_cvtli((f)[0].v.tlong)
#define	cvt_long_float(t, f)			(t)[0].v.tfloat = soft_cvtlf((f)[0].v.tlong)
#define	cvt_long_double(t, f)			(t)[0].v.tdouble = soft_cvtld((f)[0].v.tlong)
#define	cvt_float_long(t, f)			(t)[0].v.tlong = soft_cvtfl((f)[0].v.tfloat)
#define	cvt_double_long(t, f)			(t)[0].v.tlong = soft_cvtdl((f)[0].v.tdouble)

#endif


#define	move_int_const(t, c)			(t)[0].v.tint = c;
#define	move_ref_const				move_int_const
#define	move_label_const			move_ref_const

#define	move_int(t, f)				(t)[0].v.tint = (f)[0].v.tint
#define	move_ref				move_int
#define	move_any				move_long

#define	swap_int(t1, t2)			{			   \
						  jint tmp = (t1)[0].v.tint;   \
						  (t1)[0].v.tint = (t2)[0].v.tint; \
						  (t2)[0].v.tint = tmp;        \
						}

#define	load_int(t, f)				(t)[0].v.tint = *(jint*)((f)[0].v.taddr)
#define	load_ref				load_int
#define	load_any				load_int
#define	load_byte(t, f)				(t)[0].v.tint = *(jbyte*)((f)[0].v.taddr)
#define	load_char(t, f)				(t)[0].v.tint = *(jchar*)((f)[0].v.taddr)

#define	store_int(t, f)				*(jint*)((t)[0].v.taddr) = ((f)[0].v.tint)
#define	store_ref				store_int
#define	store_any				store_int
#define	store_byte(t, f)			*(jbyte*)((t)[0].v.taddr) = ((f)[0].v.tint)
#define	store_char(t, f)			*(jchar*)((t)[0].v.taddr) = ((f)[0].v.tint)

#define	add_int_const(t, f, c)			(t)[0].v.tint = ((f)[0].v.tint) + (c)
#define	add_ref_const				add_int_const
#define	sub_int_const(t, f, c)			(t)[0].v.tint = ((f)[0].v.tint) - (c)
#define	mul_int_const(t, f, c)			(t)[0].v.tint = ((f)[0].v.tint) * (c)

#define	add_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) + ((f2)[0].v.tint)
#define	add_ref					add_int
#define	sub_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) - ((f2)[0].v.tint)
#define	mul_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) * ((f2)[0].v.tint)
#define	div_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) / ((f2)[0].v.tint)
#define	rem_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) % ((f2)[0].v.tint)
#define	neg_int(t, f)				(t)[0].v.tint = -((f)[0].v.tint)
#define	lshl_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) << ((f2)[0].v.tint & 31)
#define	ashr_int(t, f1, f2)			(t)[0].v.tint = ((int32)(f1)[0].v.tint) >> ((f2)[0].v.tint & 31)
#define	lshr_int(t, f1, f2)			(t)[0].v.tint = ((uint32)(f1)[0].v.tint) >> ((f2)[0].v.tint & 31)
#define	and_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) & ((f2)[0].v.tint)
#define	or_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) | ((f2)[0].v.tint)
#define	xor_int(t, f1, f2)			(t)[0].v.tint = ((f1)[0].v.tint) ^ ((f2)[0].v.tint)

#define	cvt_int_byte(t, f)			(t)[0].v.tint = (((f)[0].v.tint) << 24) >> 24
#define	cvt_int_char(t, f)			(t)[0].v.tint = ((f)[0].v.tint) & 0xFF
#define	cvt_int_short(t, f)			(t)[0].v.tint = (((f)[0].v.tint) << 16) >> 16

#define	cmp_int_const(t, f, c)			cc = ((f)[0].v.tint) - (c)
#define	cmp_ref_const				cmp_int_const
#define	cmp_int(t, f1, f2)			cc = ((f1)[0].v.tint) - ((f2)[0].v.tint)
#define	cmp_ref					cmp_int

#define	branch_indirect(w)			w
#define	branch_a(w)				w
#define	branch_eq(w)				if (cc == 0) w
#define	branch_ne(w)				if (cc != 0) w
#define	branch_lt(w)				if (cc < 0) w
#define	branch_le(w)				if (cc <= 0) w
#define	branch_gt(w)				if (cc > 0) w
#define	branch_ge(w)				if (cc >= 0) w

#define	call(m)					virtualMachine((methods*)(m)[0].v.taddr, &lcl[meth->localsz+sp])
#define	ret()					goto end

#define	returnarg_int()				(retarg)
#define	returnarg_ref				returnarg_int

#define	pusharg_int_const(c)			/* Not needed for interpreter */
#define	pusharg_int(f)				/* Not needed for interpreter */
#define	pusharg_ref				pusharg_int
#define	pusharg_ref_const			pusharg_int_const
#define	pusharg_any(f)				/* Not needed for interpreter */
#define	pusharg_anylong(f)			/* Not needed for interpreter */
#define	popargs(n)				/* Not needed for interpreter */

#define	method_arg(i)				'I'

#define	return_int(s)				(s)[0].v.tint = retarg[0].v.tint
#define	return_long(s)				(s)[0].v.tlong = retarg[0].v.tlong
#define	return_float(s)				(s)[0].v.tfloat = retarg[0].v.tfloat
#define	return_double(s)			(s)[0].v.tdouble = retarg[0].v.tdouble
#define	return_ref(s)				(s)[0].v.taddr = retarg[0].v.taddr

#define	monitor_enter()				/* Not needed for interpreter */
#define	monitor_exit()				/* Not needed for interpreter */

#define	start_function()			/* Not needed for interpreter */
#define	start_basic_block()			/* Not needed for interpreter */
#define	end_basic_block()			/* Not needed for interpreter */
#define	end_function()				/* Not needed for interpreter */

#define	set_label(l)				label_##l:
#define	reference_code_label(l)			npc = (l)
#define	reference_label(l)			goto label_##l
#define	reference_table_label(l)		(jint)&code[npc]
#define	stored_code_label(l)			npc = (l)[0].v.tint
#define	table_code_label(l)			npc = (l)[0].v.tint + pc

#define	load_key(t, f)				(t)[0].v.tint = \
	((((uint8*)(f)->v.taddr)[0] << 24) | (((uint8*)(f)->v.taddr)[1] << 16) | \
	(((uint8*)(f)->v.taddr)[2] << 8) | ((uint8*)(f)->v.taddr)[3])
#define	load_code_ref				load_key

#define	breakpoint()				abort()

#define	move_double(t, f)			(t)[0].v.tdouble = (f)[0].v.tdouble
#define	move_double_const(t, c)			(t)[0].v.tdouble = (c)
#define	move_float(t, f)			(t)[0].v.tfloat = (f)[0].v.tfloat
#define	move_float_const(t, c)			(t)[0].v.tfloat = (c)
#define	move_long(t, f)				(t)[0].v.tlong = (f)[0].v.tlong
#define	move_anylong				move_long

#define	load_short(t, f)			(t)[0].v.tint = *(jshort*)((f)[0].v.taddr)
#define	load_long(t, f)				(t)[0].v.tlong = *(jlong*)((f)[0].v.taddr)
#define	load_anylong				load_long
#define	load_float(t, f)			(t)[0].v.tfloat = *(jfloat*)((f)[0].v.taddr)
#define	load_double(t, f)			(t)[0].v.tdouble = *(jdouble*)((f)[0].v.taddr)

#define	store_short(t, f)			*(jshort*)((t)[0].v.taddr) = ((f)[0].v.tint)
#define	store_long(t, f)			*(jlong*)((t)[0].v.taddr) = ((f)[0].v.tlong)
#define	store_anylong				store_long
#define	store_float(t, f)			*(jfloat*)((t)[0].v.taddr) = ((f)[0].v.tfloat)
#define	store_double(t, f)			*(jdouble*)((t)[0].v.taddr) = ((f)[0].v.tdouble)

#define	add_float(t, f1, f2)			(t)[0].v.tfloat = (f1)[0].v.tfloat + (f2)[0].v.tfloat
#define	add_double(t, f1, f2)			(t)[0].v.tdouble = (f1)[0].v.tdouble + (f2)[0].v.tdouble
#define	sub_float(t, f1, f2)			(t)[0].v.tfloat = (f1)[0].v.tfloat - (f2)[0].v.tfloat
#define	sub_double(t, f1, f2)			(t)[0].v.tdouble = (f1)[0].v.tdouble - (f2)[0].v.tdouble
#define	mul_float(t, f1, f2)			(t)[0].v.tfloat = (f1)[0].v.tfloat * (f2)[0].v.tfloat
#define	mul_double(t, f1, f2)			(t)[0].v.tdouble = (f1)[0].v.tdouble * (f2)[0].v.tdouble
#define	div_float(t, f1, f2)			(t)[0].v.tfloat = (f1)[0].v.tfloat / (f2)[0].v.tfloat
#define	div_double(t, f1, f2)			(t)[0].v.tdouble = (f1)[0].v.tdouble / (f2)[0].v.tdouble
#define	rem_float(t, f1, f2)			(t)[0].v.tfloat = remainderf((f1)[0].v.tfloat, (f2)[0].v.tfloat)
#define	rem_double(t, f1, f2)			(t)[0].v.tdouble = remainder((f1)[0].v.tdouble, (f2)[0].v.tdouble)
#define	neg_float(t, f)				(t)[0].v.tfloat = -(f)[0].v.tfloat
#define	neg_double(t, f)			(t)[0].v.tdouble = -(f)[0].v.tdouble

#define	cmpg_float(t, f1, f2)			(t)[0].v.tint = soft_fcmpg((f1)[0].v.tfloat, (f2)[0].v.tfloat)
#define	cmpg_double(t, f1, f2)			(t)[0].v.tint = soft_dcmpg((f1)[0].v.tdouble, (f2)[0].v.tdouble)
#define	cmpl_float(t, f1, f2)			(t)[0].v.tint = soft_fcmpl((f1)[0].v.tfloat, (f2)[0].v.tfloat)
#define	cmpl_double(t, f1, f2)			(t)[0].v.tint = soft_dcmpl((f1)[0].v.tdouble, (f2)[0].v.tdouble)

#define	cvt_int_float(t, f)			(t)[0].v.tfloat = (f)[0].v.tint
#define	cvt_int_double(t, f)			(t)[0].v.tdouble = (f)[0].v.tint
#define	cvt_float_int(t, f)			(t)[0].v.tint = (f)[0].v.tfloat
#define	cvt_float_double(t, f)			(t)[0].v.tdouble = (f)[0].v.tfloat
#define	cvt_double_int(t, f)			(t)[0].v.tint = (f)[0].v.tdouble
#define	cvt_double_float(t, f)			(t)[0].v.tfloat = (f)[0].v.tdouble

#define	returnarg_double			returnarg_int
#define	returnarg_float				returnarg_int
#define	returnarg_long				returnarg_int

#define	softcall_lookupmethod(r, n, t)		(r)[0].v.taddr = soft_lookupmethod((t)[0].v.taddr, (n))
#define	softcall_new(r, t)			(r)[0].v.taddr = soft_new((t)[0].v.taddr)
#define	softcall_newarray(r, s, t)		(r)[0].v.taddr = soft_newarray(t, (s)[0].v.tint)
#define	softcall_anewarray(r, s, t)		(r)[0].v.taddr = soft_anewarray((t)[0].v.taddr, (s)[0].v.tint)
#define	softcall_athrow(s)			soft_athrow((s)[0].v.taddr)
#define	softcall_checkcast(o, t)		soft_checkcast((t)[0].v.taddr, (o)[0].v.taddr)
#define	softcall_instanceof(r, o, t)		(r)[0].v.tint = soft_instanceof((t)[0].v.taddr, (o)[0].v.taddr)
#define	softcall_monitorenter(o)		soft_monitorenter((o)[0].v.taddr)
#define	softcall_monitorexit(o)			soft_monitorexit((o)[0].v.taddr)
#define	softcall_multianewarray(r, z, s, t)	(r)[0].v.taddr = soft_multianewarray((t)[0].v.taddr, z, s)

#define	softcall_badarrayindex()		soft_badarrayindex()

#define	adjustpc(a)				/* Not needed for interpreter */

#endif
