/*
 * file.h
 * File support routines.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __file_h
#define __file_h

#include "gtypes.h"

typedef struct _classFile {
	unsigned char*	base;
	unsigned char*	buf;
	int		size;
} classFile;

#define	readu1(c,f)	(*(c) = f->buf[0], f->buf += 1)
#define	readu2(c,f)	(*(c) = (f->buf[0] << 8) | f->buf[1], f->buf += 2)
#define	readu4(c,f)	(*(c) = (f->buf[0] << 24)|(f->buf[1] << 16)|\
				(f->buf[2] << 8)|f->buf[3], f->buf += 4)
#if defined(HAVE_NATIVE_INT64)
#define	readu8(c,f)	(*(c) = \
			((uint64)f->buf[0] << 56)|((uint64)f->buf[1] << 48)|\
			((uint64)f->buf[2] << 40)|((uint64)f->buf[3] << 32)|\
			((uint64)f->buf[4] << 24)|((uint64)f->buf[5] << 16)|\
			((uint64)f->buf[6] <<  8)|((uint64)f->buf[7]),\
			f->buf += 8)
#else
#define	readu8(c,f)	(readu4(&((c)->jh),f), \
			 readu4(&((c)->jl),f))
#endif

#define	readm(b,l,s,f)	(memcpy(b, f->buf, (l)*(s)), f->buf += (l)*(s))
#define	seekm(f,l)	(f->buf += (l))

#endif
