/*
 * external.h
 * Handle method calls to other languages.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __external_h
#define __external_h

#define	MAXSTUBLEN	1024
#define	MAXLIBPATH	1024
#define	MAXLIBS		16

/* Default library info. */
#define	LIBRARYPATH	"LD_LIBRARY_PATH"
#define	NATIVELIBRARY	"libkaffe_native"

/*
 * Define the Kaffe function call routine.
 *  'func' is a pointer to the method block.
 *  'obj' is the object. 
 *  'nargs' is the number of arguments.
 *  'argptr' is a pointer to the arguments.
 */
#if defined(INTERPRETER)
#ifndef BEOS
#define	CALL_KAFFE_FUNCTION_VARARGS(func, obj, nargs, argptr)		\
	{								\
		int i;							\
		va_list ap = (argptr);					\
		slots* kargs = alloca(sizeof(slots) * ((nargs) + 1));	\
		for (i = 0; i < (nargs); i++) {				\
			kargs[(nargs)-i-1].v.tint = va_arg(ap, jint);	\
		}							\
		kargs[(nargs)].v.tint = (jint)obj;			\
		virtualMachine((func), kargs);				\
	}
#else
#define	CALL_KAFFE_FUNCTION_VARARGS(func, obj, nargs, argptr)		\
	{								\
		int i;							\
		va_list ap = (argptr);					\
		slots* kargs = malloc(sizeof(slots) * ((nargs) + 1));	\
		for (i = 0; i < (nargs); i++) {				\
			kargs[(nargs)-i-1].v.tint = va_arg(ap, jint);	\
		}							\
		kargs[(nargs)].v.tint = (jint)obj;			\
		virtualMachine((func), kargs);				\
		free(kargs); \
	}
#endif 
#endif
struct _methods;

void	initNative(void);
int	loadNativeLibrary(char*);
void	native(struct _methods*);

#endif
