/*
 * constants.h
 * Manage constants.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

/* COPYRIGHT */

#ifndef __constant_h
#define __constant_h

/*
 * Constant pool definitions.
 */
#define	CONSTANT_Class			7
#define	CONSTANT_Fieldref		9
#define	CONSTANT_Methodref		10
#define	CONSTANT_InterfaceMethodref	11
#define	CONSTANT_String			8
#define	CONSTANT_Integer		3
#define	CONSTANT_Float			4
#define	CONSTANT_Long			5
#define	CONSTANT_Double			6
#define	CONSTANT_NameAndType		12
#define	CONSTANT_Utf8			1
#define	CONSTANT_Unicode		2

#define	CONSTANT_LongC			129
#define	CONSTANT_DoubleC		130

#define	CONSTANT_Unknown		0
#define	CONSTANT_Chararray		128

typedef u2	constIndex;

struct _slots;

typedef struct _constants {
	u2		size;
	u1*		tags;
	struct _slots*	data;
} constants;

#define	STRHASHSZ		128

typedef struct _strconst {
	struct _strconst*	next;
	struct _stringClass*	string;
	object			obj;
	char			data[1];
} strconst;

#define	STRING_DATA2BASE(i)	(strconst*)(((int)i) - (sizeof(object)+sizeof(strconst*)+sizeof(strconst*)))
#define	STRING_OBJ2DATA(i)	(char*)(((int)i) + sizeof(object))

typedef struct _strpair {
	struct _strpair*	next;
	uint32			hash;
	char*			s1;
	char*			s2;
} strpair;

/*
 * Macros to take constant pools apart.
 */
#define	METHODREF_CLASS(idx, pool)		(pool->data[idx].v.tint & 0xFFFF)
#define	METHODREF_NAMEANDTYPE(idx, pool)	(pool->data[idx].v.tint >> 16)
#define	CLASS_NAME(idx, pool)			(pool->data[idx].v.tint)
#define	FIELDREF_CLASS(idx, pool)		METHODREF_CLASS(idx, pool)
#define	FIELDREF_NAMEANDTYPE(idx, pool)		METHODREF_NAMEANDTYPE(idx, pool)
#define	NAMEANDTYPE_NAME(idx, pool)		METHODREF_CLASS(idx, pool)
#define	NAMEANDTYPE_SIGNATURE(idx, pool)	METHODREF_NAMEANDTYPE(idx, pool)
#define	STRING_NAME(idx, pool)			CLASS_NAME(idx, pool)

struct _classFile;

constants*	readConstantPool(struct _classFile*);

char*		addStringConstant(strconst*);
strpair*	addStringConstantPair(char*, char*);
strpair*	lookupStringPair(char*, char*);

#endif
