/* code.h
 * Define a code module.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __code_h
#define __code_h


union _attribute_info;
struct _jexception;

typedef struct _Code {
	u2			max_stack;
	u2			max_locals;
	u4			code_length;
	u1*			code;
	u2			exception_table_length;
	struct _jexception*	exception_table;
	u2			attribute_count;
	union _attribute_info*	attributes;
} Code;

struct _methods;
struct _classFile;

void	addCode(struct _methods*, uint32, struct _classFile*);

#endif
