/*
 * code.c
 * Process a new code attribute.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#define	DBG(s)

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include "gtypes.h"
#include "file.h"
#include "errors.h"
#include "bytecode.h"
#include "code.h"
#include "access.h"
#include "object.h"
#include "constants.h"
#include "classMethod.h"
#include "readClass.h"
#include "slots.h"
#include "exception.h"

void
addCode(methods* m, uint32 len, classFile* fp)
{
	Code c;
	int i;
	u2 i2;

	readu2(&c.max_stack, fp);
	readu2(&c.max_locals, fp);
	readu4(&c.code_length, fp);
DBG(	printf("Max stack = %d\n", c.max_stack);	)
DBG(	printf("Max locals = %d\n", c.max_locals);	)
DBG(	printf("Code length = %d\n", c.code_length);	)
	if (c.code_length > 0) {
		c.code = malloc(c.code_length);
		if (c.code == 0) {
                        throwException(OutOfMemoryError);
		}
		readm(c.code, c.code_length, sizeof(bytecode), fp);
	}
	else {
		c.code = 0;
	}
	readu2(&c.exception_table_length, fp);
DBG(	printf("Exception table length = %d\n", c.exception_table_length);	)
	if (c.exception_table_length > 0) {
		c.exception_table = malloc(c.exception_table_length * sizeof(jexception));
		if (c.exception_table == 0) {
                        throwException(OutOfMemoryError);
		}
		for (i = 0; i < c.exception_table_length; i++) {
			readu2(&i2, fp);
			c.exception_table[i].start_pc = i2;
			readu2(&i2, fp);
			c.exception_table[i].end_pc = i2;
			readu2(&i2, fp);
			c.exception_table[i].handler_pc = i2;
			readu2(&i2, fp);
			if (i2 == 0) {
				c.exception_table[i].catch_type = 0;
			}
			else {
				assert(m->constants->tags[i2] == CONSTANT_Class);
				c.exception_table[i].catch_type = m->constants->data[CLASS_NAME(i2, m->constants)].v.tstr;
			}
		}
	}
	else {
		c.exception_table = 0;
	}
	addMethodCode(m, &c);

	readAttributes(fp, m->class, m);
}
