/*
 * baseClasses.h
 * Handle base classes.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __baseclasses_h
#define __baseclasses_h

#include "object.h"

typedef struct _stringClass {
	object		head;
	object*		value;
	int		offset;
	int		count;
} stringClass;

#define	STRINGCLASS	"java/lang/String"
#define	STRINGINIT	"<init>"
#define	STRINGINITSIG	"([C)V"

#define	OBJECTCLASS	"java/lang/Object"
#define	CLASSCLASS	"java/lang/Class"

#define	CLONEABLECLASS	"java/lang/Cloneable"

void		initBaseClasses(void);

struct _strconst;
struct _strpair;
struct _constants;
struct _classes;
struct _slots;

char*		addString(char*);
struct _strpair* addStringPair(char*, char*);
stringClass*	getString(struct _strconst*);
struct _slots*	makeStringObject(int, struct _constants*);
void		initClasses(void);

extern char* ObjectClassName;
extern struct _classes*	ObjectClass;
extern struct _classes*	ClassClass;
extern struct _classes*	ClassString;

#endif
