/*
 * main.c
 * Generate native code stubs from .class files.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>

#define	BUFSZ	100
#define	PATHSZ	1024

FILE* include;
FILE* stub;
char className[BUFSZ];
char pathName[BUFSZ];
char includeName[BUFSZ];
char stubName[BUFSZ];
char realClassPath[PATHSZ];

int flag_shrt = 0;
int flag_stub = 0;

static void usage(void);
static int options(char**);

/*
 * MAIN
 */
int
main(int argc, char* argv[])
{
	char* nm;
	int i;
	int farg;

	/* Process arguments */
	farg = options(argv);

	if (argv[farg] == 0) {
		usage();
		exit(1);
	}

	for (nm = argv[farg]; nm != 0; nm = argv[++farg]) {
		for (i = 0; nm[i] != 0; i++) {
			switch (nm[i]) {
			case '/':
			case '.':
				className[i] = '_';
				pathName[i] = '/';
				includeName[i] = '_';
				stubName[i] = '_';
				break;
			default:
				className[i] = nm[i];
				pathName[i] = nm[i];
				includeName[i] = nm[i];
				stubName[i] = nm[i];
				break;
			}
		}
		className[i] = 0;
		pathName[i] = 0;
		includeName[i] = 0;
		stubName[i] = 0;

		/* If we are in 'base' mode, truncate the include and stub name
		 * to just the basename.
		 */
		if (flag_shrt == 1) {
			for (i = strlen(stubName); i >= 0; i--) {
				if (stubName[i] == '_') {
					strcpy(stubName, &stubName[i+1]);
					break;
				}
			}
			for (i = strlen(includeName); i >= 0; i--) {
				if (includeName[i] == '_') {
					strcpy(includeName, &includeName[i+1]);
					break;
				}
			}
		}

		strcat(includeName, ".h");
		strcat(stubName, "Stub.c");

		if (flag_stub == 0) {
			include = fopen(includeName, "w");;
			if (include == 0) {
				fprintf(stderr, "Failed to create '%s'.\n", includeName);
				exit(1);
			}
			startInclude();
		}
		else {
			stub = fopen(stubName, "w");;
			if (stub == 0) {
				fprintf(stderr, "Failed to create '%s'.\n", stubName);
				exit(1);
			}
			startStub();
		}

#if 0
		strcat(pathName, ".class");
		fp = fopen(pathName, "rb");;
		if (fp == 0) {
			fprintf(stderr, "Failed to open '%s'.\n", pathName);
			exit(1);
		}
		readClass(fp);
#endif
		findClass(pathName);

		if (stub != 0) {
			fclose(stub);
		}
		if (include != 0) {
			endInclude();
			fclose(include);
		}
	}
	exit(0);
}

/*
 * Process program's flags.
 */
static
int
options(char** argv)
{
	int i;

	for (i = 1; argv[i] != 0; i++) {
		if (argv[i][0] != '-') {
			break;
		}

		if (strcmp(argv[i], "-help") == 0) {
			usage();
			exit(0);
		}
		else if (strcmp(argv[i], "-version") == 0) {
			fprintf(stderr, "Kaffeh version %s ", KVER);
			fprintf(stderr, "(c) Copyright Tim Wilkinson\n");
			fprintf(stderr, "Systems Architecture Research Centre, City University, UK.\n");
			exit(0);
		}
		else if (strcmp(argv[i], "-base") == 0) {
			flag_shrt = 1;
		}
		else if (strcmp(argv[i], "-stubs") == 0) {
			flag_stub = 1;
		}
		else if (strcmp(argv[i], "-classpath") == 0) {
			i++;
			strcpy(realClassPath, argv[i]);
		}
		else {
			fprintf(stderr, "Unknown flag: %s\n", argv[i]);
		}
	}

	/* Return first no-flag argument */
	return (i);
}

/*
 * Print usage message.
 */
static
void
usage(void)
{
	fprintf(stderr, "usage: kaffeh [-options] class ...\n");
	fprintf(stderr, "Options are:\n");
	fprintf(stderr, "	-help			Print this message\n");
	fprintf(stderr, "	-version		Print version number\n");
	fprintf(stderr, "	-classpath <path>	Set classpath\n");
	fprintf(stderr, "	-stubs			Generate stub rather than include\n");
	fprintf(stderr, "	-base			Truncate stub and include names\n");
}
