/*
 * main.c
 * Kick off program.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "gtypes.h"
#include "access.h"
#include "object.h"
#include "constants.h"
#include "classMethod.h"
#include "baseClasses.h"
#include "thread.h"
#include "slib.h"

void initialise(void);
object* alloc_objectarray(int, char*);
stringClass* makeJavaString(char*, int);
long do_execute_java_class_method(char*, char*, char*, ...);
void killThread(thread*);

extern int flag_optimise;
extern int flag_verify;
extern char realClassPath[];
extern int threadStackSize;

static int options(char**);
static void usage(void);

#define	MAIN		"main"
#define	MAINSIG		"([Ljava/lang/String;)V"
#define	STRINGSIG	"Ljava/lang/String;"

/*
 * MAIN
 */
int
main(int argc, char* argv[])
{
	classes* class;
	void* func;
	object* args;
	stringClass** str;
	int i;
	int farg;

	/* Process program options */
	farg = options(argv);

	/* Get the class name to start with */
	if (argv[farg] == 0) {
		usage();
		exit(1);
	}

	/* Initialise */
	initialise();

	/* Build an array of strings as the arguments */
	args = alloc_objectarray(argc-(farg+1), STRINGSIG);

	/* Build each string and put into the array */
	str = (stringClass**)(args+1);
	for (i = farg+1; i < argc; i++) {
		str[i-(farg+1)] = makeJavaString(argv[i], strlen(argv[i]));
	}

	/* Kick it */
	do_execute_java_class_method(argv[farg], MAIN, MAINSIG, args);
	killThread(0);
	/* This should never return */
	exit(1);
	return(1);
}

/*
 * Process program's flags.
 */
static
int
options(char** argv)
{
	int i;
	int sz;

	for (i = 1; argv[i] != 0; i++) {
		if (argv[i][0] != '-') {
			break;
		}

		if (strcmp(argv[i], "-help") == 0) {
			usage();
			exit(0);
		}
		else if (strcmp(argv[i], "-version") == 0) {
			fprintf(stderr, "Kaffe version %s ", KVER);
			fprintf(stderr, "(c) Copyright Tim Wilkinson\n");
			fprintf(stderr, "Systems Architecture Research Centre, City University, UK.\n");
			exit(0);
		}
#ifndef BEOS
		else if (strcmp(argv[i], "-O") == 0) {
			flag_optimise = 1;
		}
#endif
		else if (strcmp(argv[i], "-classpath") == 0) {
			i++;
			if (argv[i] == 0) {
				fprintf(stderr, "Error: No path found for -classpath option.\n");
				exit(1);
			}
			strcpy(realClassPath, argv[i]);
		}
#ifndef BEOS
		else if (strcmp(argv[i], "-ss") == 0) {
			i++;
			if (argv[i] == 0) {
				fprintf(stderr, "Error: No stack size found for -ss option.\n");
				exit(1);
			}
			sz = atol(argv[i]);
			if (sz < threadStackSize) {
				fprintf(stderr, "Warning: Attempt to set stack size smaller than %d - ignored.\n", threadStackSize);
			}
			else {
				threadStackSize = sz;
			}
		}
		else if (strcmp(argv[i], "-verify") == 0) {
			flag_verify = 3;
		}
		else if (strcmp(argv[i], "-verifyremote") == 0) {
			flag_verify = 2;
		}
		else if (strcmp(argv[i], "-noverify") == 0) {
			flag_verify = 0;
		}
#endif
		else {
			fprintf(stderr, "Unknown flag: %s\n", argv[i]);
		}
	}

	/* Return first no-flag argument */
	return (i);
}

/*
 * Print usage message.
 */
static
void
usage(void)
{
	fprintf(stderr, "usage: kaffe [-options] class\n");
	fprintf(stderr, "Options are:\n");
	fprintf(stderr, "	-help			Print this message\n");
	fprintf(stderr, "	-version		Print version number\n");
	fprintf(stderr, "	-O			Enable code optimisations (work in progress)\n");
	fprintf(stderr, "	-ss <size>		Maximum native stack size\n");
	fprintf(stderr, "	-classpath <path>	Set classpath\n");
	fprintf(stderr, "	-verify			Verify all bytecode (not yet)\n");
	fprintf(stderr, "	-verifyremote		Verify bytecode loaded from network (not yet)\n");
	fprintf(stderr, "	-noverify		Do not verify any bytecode\n");
#ifdef notyet
	fprintf(stderr, "	-v, -verbose		\n");
	fprintf(stderr, "	-debug			\n");
	fprintf(stderr, "	-noasyncgc		\n");
	fprintf(stderr, "	-verbosegc		\n");
	fprintf(stderr, "	-cs, -checksource	\n");
	fprintf(stderr, "	-ms			Initial heap size\n");
	fprintf(stderr, "	-mx			Maximum heap size\n");
	fprintf(stderr, "	-prof			\n");
#endif
}
