/*
 * i386/jit.h
 * Common i386 JIT configuration information.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#ifndef __i386_jit_h
#define __i386_jit_h

/**/
/* Native function invocation. */
/**/
#define	CALL_KAFFE_FUNCTION_VARARGS(func, obj, nargs, argptr)		\
	asm("	pushal							\n\
		movl %%esp,%%ebp					\n\
1:		cmpl $0,%2						\n\
		je 2f							\n\
		decl %2							\n\
		pushl (%3,%2,4)						\n\
		jmp 1b							\n\
2:									\n\
		pushl %1						\n\
		call *%0						\n\
		movl %%ebp,%%esp					\n\
		popal" : : "r" (func), "r" (obj), "r" (nargs), "r" (argptr))

/**/
/* Exception handling information. */
/**/

extern struct _thread* currentThread;

/* Structure of exception frame on stack */
typedef struct _exceptionFrame {
        uintp	retbp;
        uintp	retpc;
} exceptionFrame;

/* Is this frame valid (ie. is it on the current stack) ? */
#define	FRAMEOKAY(f)							\
	((f)->retbp >= (int)currentThread->PrivateInfo->stackBase &&	\
	 (f)->retbp < (int)currentThread->PrivateInfo->stackEnd)

/* Get the next frame in the chain */
#define	NEXTFRAME(f)							\
	((exceptionFrame*)(f)->retbp)

/* Extract the PC from the given frame */
#define	PCFRAME(f)							\
	((f)->retpc-1)

/* Get the first exception frame from a subroutine call */
#define	FIRSTFRAME(f, o)						\
	(f) = *((exceptionFrame*)(((uintp)&(o))-8))

/* Call the relevant exception handler (rewinding the stack as
   necessary). */
#define CALL_KAFFE_EXCEPTION(frame, info, obj)				\
        asm("   movl %2,%%eax						\n\
		movl %0,%%ebp						\n\
		jmp *%1							\n\
		" : : "g" (frame->retbp), "r" (info.handler), "g" (obj) : "eax")

/**/
/* Register management information. */
/**/

/* Define the register set */
#define	REGISTER_SET							\
	{ /* eax */	0, 0, Rint|Rref,	0, 0    },		\
	{ /* ecx */	0, 0, Rint|Rref,	0, 0    },		\
	{ /* edx */	0, 0, Rint|Rref,	0, 0    },		\
	{ /* ebx */	0, 0, Rint|Rref,	0, 0    },		\
	{ /* esp */	0, 0, Reserved,		0, 0    },		\
	{ /* ebp */	0, 0, Reserved,		0, 0    },		\
	{ /* esi */	0, 0, Reserved,		0, 0    },		\
	{ /* edi */	0, 0, Reserved,		0, 0    },		\
	{ /* f0  */	0, 0, Rfloat|Rdouble,	1, 0    },

/* Number of registers in the register set */
#define	NR_REGISTERS	9

/* Define which registers are used for which return values */
#define	RETURN_INT		0	/* eax */
#define	RETURN_REF		0	/* eax */
#define	RETURN_LONG_LOW		0	/* eax */
#define	RETURN_LONG_HIGH	2	/* edx */
#define	RETURN_FLOAT		8	/* f0 */
#define	RETURN_DOUBLE_LOW	8	/* f0 */
#define	RETURN_DOUBLE_HIGH	0	/* Not used in this configuration */

/**/
/* Opcode generation. */
/**/

/* Define if generated code uses two operands rather than one */
#define	TWO_OPERAND

/**/
/* Slot management information. */
/**/

/* Size of each slot */
#define	SLOTSIZE	4

/* Generate slot offset for an argument */
#define SLOT2ARGOFFSET(_n)	(8 + SLOTSIZE * (_n))

/* Generate slot offset for a local (non-argument) */
#define SLOT2LOCALOFFSET(_n)	(-SLOTSIZE * (maxTemp+maxLocal+maxStack - (_n)))

#endif
