/* i386/jit-icode.h
 * Define the instructions which are present on the i386.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, June 1996.
 */

#ifndef __icode_h
#define __icode_h

/*
 * Refs and int/long registers are equivalent.
 */
#define	HAVE_ref_eq_int
#undef	HAVE_ref_eq_long

/*
 * These must be defined for any architecture.
 */
#define	HAVE_spill_int			spill_Rxx
#define	HAVE_reload_int			reload_Rxx
#define	HAVE_spill_float		fspill_Rxx
#define	HAVE_reload_float		freload_Rxx
#define	HAVE_spill_double		fspilll_Rxx
#define	HAVE_reload_double		freloadl_Rxx
#define	HAVE_prologue			prologue_xxx
#define	HAVE_epilogue			epilogue_xxx

#define	HAVE_move_int_const		move_RxC
#define	HAVE_move_int			move_RxR
#define	HAVE_move_float_const		fmove_RxC
#define	HAVE_move_float			fmove_RxR
#define	HAVE_move_double_const		fmovel_RxC
#define	HAVE_move_double		fmovel_RxR
#define	HAVE_move_label_const		move_RxL

#define	HAVE_add_int			add_RRR
#define	HAVE_sub_int			sub_RRR
#define	HAVE_mul_int			mul_RRR
#define	HAVE_div_int			div_RRR
#define	HAVE_rem_int			rem_RRR
#define	HAVE_and_int			and_RRR
#define	HAVE_or_int			or_RRR
#define	HAVE_xor_int			xor_RRR
#define	HAVE_ashr_int			ashr_RRR
#define	HAVE_lshr_int			lshr_RRR
#define	HAVE_lshl_int			lshl_RRR

#define	HAVE_add_float			fadd_RRR
#define	HAVE_sub_float			fsub_RRR
#define	HAVE_mul_float			fmul_RRR
#define	HAVE_div_float			fdiv_RRR

#define	HAVE_add_double			faddl_RRR
#define	HAVE_sub_double			fsubl_RRR
#define	HAVE_mul_double			fmull_RRR
#define	HAVE_div_double			fdivl_RRR

#define	HAVE_load_int			load_RxR
#define	HAVE_store_int			store_RxR

#define	HAVE_load_float			fload_RxR
#define	HAVE_store_float		fstore_RxR
#define	HAVE_load_double		floadl_RxR
#define	HAVE_store_double		fstorel_RxR

#define	HAVE_pusharg_int		push_xxR
#define	HAVE_pusharg_float		fpush_xxR
#define	HAVE_pusharg_double		fpushl_xxR
#define	HAVE_popargs			popargs_xxC

#define	HAVE_cmp_int			cmp_xRR

#define	HAVE_branch			branch_xCC
#define	HAVE_branch_indirect		branch_indirect_xRC
#define	HAVE_call_ref			call_xCC
#define	HAVE_call			call_xRC
#define	HAVE_ret			ret_xxx
#define	HAVE_return_int			return_Rxx
#define	HAVE_return_long		returnl_Rxx
#define	HAVE_return_float		freturn_Rxx
#define	HAVE_return_double		freturnl_Rxx

#define	HAVE_set_label			set_label_xxC
#define	HAVE_build_key			set_word_xxC
#define	HAVE_build_code_ref		set_wordpc_xxC

#define	HAVE_cvt_int_double		cvtid_RxR
#define	HAVE_cvt_long_double		cvtld_RxR
#define	HAVE_cvt_float_int		cvtfi_RxR
#define	HAVE_cvt_double_int		cvtdi_RxR
#define	HAVE_cvt_float_long		cvtfl_RxR
#define	HAVE_cvt_double_long		cvtdl_RxR
#define	HAVE_cvt_long_float		cvtlf_RxR
#define	HAVE_cvt_int_float		cvtif_RxR
#define	HAVE_cvt_float_double		cvtfd_RxR
#define	HAVE_cvt_double_float		cvtdf_RxR

/*
 * These are sometimes optional (if long operators are defined)
 */
#define	HAVE_adc_int			adc_RRR
#define	HAVE_sbc_int			sbc_RRR

/*
 * These are optional if the architecture supports them.
 */
#undef	HAVE_add_int_const
#undef	HAVE_sub_int_const
#undef	HAVE_mul_int_const

#undef	HAVE_cmp_int_const

#undef	HAVE_cmpg_float
#undef	HAVE_cmpg_double
#undef	HAVE_cmpl_float
#undef	HAVE_cmpl_double

#undef	HAVE_load_int_addregconst

#undef	HAVE_pusharg_int_const

#undef	HAVE_swap_int
#undef	HAVE_neg_int

#undef	HAVE_move_long_const
#undef	HAVE_move_long

#undef	HAVE_add_long
#undef	HAVE_sub_long
#undef	HAVE_mul_long
#undef	HAVE_div_long
#undef	HAVE_rem_long
#undef	HAVE_neg_long
#undef	HAVE_and_long
#undef	HAVE_or_long
#undef	HAVE_xor_long
#undef	HAVE_ashr_long
#undef	HAVE_lshl_long
#undef	HAVE_lshr_long
#undef	HAVE_and_int_const
#undef	HAVE_lshl_int_const
#undef	HAVE_ashr_int_const
#undef	HAVE_lshr_int_const

#undef	HAVE_load_long
#undef	HAVE_load_byte
#undef	HAVE_load_char
#undef	HAVE_load_short
#undef	HAVE_store_long
#undef	HAVE_store_byte
#undef	HAVE_store_char
#undef	HAVE_store_short

#undef	HAVE_pusharg_long

#undef	HAVE_cmp_long

#undef	HAVE_neg_float
#undef	HAVE_neg_double
#undef	HAVE_rem_float
#undef	HAVE_rem_double

#undef	HAVE_cvt_int_long
#undef	HAVE_cvt_int_byte
#undef	HAVE_cvt_int_char
#undef	HAVE_cvt_int_short
#undef	HAVE_cvt_long_int

/*
 * Change various branches into one branch type.
 */
#define	branch_a(l)	branch(l, ba)
#define	branch_eq(l)	branch(l, beq)
#define	branch_ne(l)	branch(l, bne)
#define	branch_lt(l)	branch(l, blt)
#define	branch_le(l)	branch(l, ble)
#define	branch_gt(l)	branch(l, bgt)
#define	branch_ge(l)	branch(l, bge)

/*
 * These are for handling unknown types.
 */
#define	move_any			move_int
#define	move_anylong			move_long
#define	pusharg_any			pusharg_int
#define	pusharg_anylong			pusharg_long
#define	load_any			load_int
#define	load_anylong			load_long
#define	store_any			store_int
#define	store_anylong			store_long

/*
 * These are architecture specific.
 * References may be int's or long's depending on the machine.
 */
#if defined(HAVE_ref_eq_int)
#define	move_ref_const			move_int_const
#define	move_ref			move_int
#define	load_ref			load_int
#define	store_ref			store_int
#define	pusharg_ref			pusharg_int
#define	pusharg_ref_const		pusharg_int_const
#define	add_ref_const			add_int_const
#define	add_ref				add_int
#define	cmp_ref_const			cmp_int_const
#define	cmp_ref				cmp_int
#define	return_ref			return_int
#elif defined(HAVE_ref_eq_long)
#define	move_ref_const			move_long_const
#define	move_ref			move_long
#define	load_ref			load_long
#define	store_ref			store_long
#define	pusharg_ref			pusharg_long
#define	pusharg_ref_const		pusharg_long_const
#define	add_ref_const			add_long_const
#define	add_ref				add_long
#define	cmp_ref_const			cmp_long_const
#define	cmp_ref				cmp_long
#define	return_ref			return_long
#endif

/*
 * These are always the same.
 */
#define	returnarg_int()			(&returninfo[returnInt])
#define	returnarg_long()		(&returninfo[returnLong])
#define	returnarg_float()		(&returninfo[returnFloat])
#define	returnarg_double()		(&returninfo[returnDouble])
#define	returnarg_ref()			(&returninfo[returnRef])

#endif
