/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/
/*
 * @(#)system_md.c	1.18 95/11/29  
 *
 */

#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>

#include <sys/time.h>

#include "timeval.h"
#include "sys_api.h"


long
sysGetMilliTicks()
{
    struct timeval tv;

    (void) gettimeofday(&tv, (void *) 0);
    return((tv.tv_sec * 1000) + (tv.tv_usec / 1000));
}

long
sysTime(long *l_p)
{
//    fprintf(stderr,"system_md.c: time() is %d\n",time((time_t *)l_p));
	return time((time_t *)l_p);
}

int64_t
sysTimeMillis()
{
	unsigned long l_p;
    struct timeval tv;

// gettimeofday() doesn't return the number of usecs since 1/1/70
// but since boot time. So we use time() to get seconds since 1/1/70
// and gettimeofday() to get msecs. Paul.

    (void) gettimeofday(&tv, (void *) 0);	
	time(&l_p);
    return ll_add(ll_mul(int2ll(l_p), int2ll(1000)), int2ll(tv.tv_usec/1000));
}

#include <time.h>

struct tm *
sysLocaltime(time_t *t, struct tm *tm)
{
    *tm = *localtime(t);

	return tm;
}

struct tm *
sysGmtime(time_t *t, struct tm *tm)
{
    *tm = *gmtime(t);
	return tm;
}

void
sysStrftime(char *buf, int buflen, char *fmt, struct tm *t)
{
    strftime(buf, buflen, fmt, t);
}

time_t sysMktime(struct tm *t)
{
    return mktime(t);
}


typedef void (*pProc)(void);

static struct exit_proc {
    pProc proc;
    struct exit_proc *next;
} *exit_procs = NULL;

void
sysExit(int status)
{
    struct exit_proc *pExit = exit_procs;
    while (pExit != NULL) {
        struct exit_proc *pNext = pExit->next;
        (*pExit->proc)();
        sysFree(pExit);
        pExit = pNext;
    }
    exit(status);
}

int
sysAtexit(void (*func)(void))
{
    struct exit_proc *pExit = sysMalloc(sizeof(struct exit_proc));
    if (pExit == NULL) {
        return 1;
    }
    pExit->proc = func;
    pExit->next = exit_procs;
    exit_procs = pExit;
    return 0;
}

void
sysAbort(void)
{
    abort();
}

/*
 * Access does not seem to work properly on BeOS. Using stat instead.
 * Since we have a single user machine, there are no permissions, 
 * i.e. if you can access a file, you can do whatever you want to it.
 * Paul.
 */


int
sysAccess(const char *p, int flags)
{

	struct stat st;
		
	return stat(p, &st);

}
